/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.serializers;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Registration;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.SerializerFactory;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.Collection;

public class CollectionSerializer<T extends Collection>
extends Serializer<T> {
    private boolean elementsCanBeNull = true;
    private Serializer elementSerializer;
    private Class elementClass;

    public CollectionSerializer() {
        this.setAcceptsNull(true);
    }

    public void setElementsCanBeNull(boolean elementsCanBeNull) {
        this.elementsCanBeNull = elementsCanBeNull;
    }

    public void setElementClass(Class elementClass) {
        this.elementClass = elementClass;
    }

    public Class getElementClass() {
        return this.elementClass;
    }

    public void setElementClass(Class elementClass, Serializer serializer) {
        this.elementClass = elementClass;
        this.elementSerializer = serializer;
    }

    public void setElementSerializer(Serializer elementSerializer) {
        this.elementSerializer = elementSerializer;
    }

    public Serializer getElementSerializer() {
        return this.elementSerializer;
    }

    @Override
    public void write(Kryo kryo, Output output, T collection) {
        Serializer elementSerializer;
        boolean elementsCanBeNull;
        block21: {
            Object genericClass;
            if (collection == null) {
                output.writeByte((byte)0);
                return;
            }
            int length = collection.size();
            if (length == 0) {
                output.writeByte(1);
                this.writeHeader(kryo, output, collection);
                return;
            }
            elementsCanBeNull = this.elementsCanBeNull;
            elementSerializer = this.elementSerializer;
            if (elementSerializer == null && (genericClass = kryo.getGenerics().nextGenericClass()) != null && kryo.isFinal((Class)genericClass)) {
                elementSerializer = kryo.getSerializer((Class)genericClass);
            }
            if (elementSerializer != null) {
                block20: {
                    if (elementsCanBeNull) {
                        for (Object element : collection) {
                            if (element != null) continue;
                            output.writeVarIntFlag(true, length + 1, true);
                            break block20;
                        }
                        output.writeVarIntFlag(false, length + 1, true);
                        elementsCanBeNull = false;
                    } else {
                        output.writeVarInt(length + 1, true);
                    }
                }
                this.writeHeader(kryo, output, collection);
            } else {
                Class<?> elementType = null;
                boolean hasNull = false;
                for (Object element : collection) {
                    if (element == null) {
                        hasNull = true;
                        continue;
                    }
                    if (elementType == null) {
                        elementType = element.getClass();
                        continue;
                    }
                    if (element.getClass() == elementType) continue;
                    output.writeVarIntFlag(false, length + 1, true);
                    this.writeHeader(kryo, output, collection);
                    break block21;
                }
                output.writeVarIntFlag(true, length + 1, true);
                this.writeHeader(kryo, output, collection);
                if (elementType == null) {
                    output.writeByte((byte)0);
                    return;
                }
                kryo.writeClass(output, elementType);
                elementSerializer = kryo.getSerializer(elementType);
                if (elementsCanBeNull) {
                    output.writeBoolean(hasNull);
                    elementsCanBeNull = hasNull;
                }
            }
        }
        if (elementSerializer != null) {
            if (elementsCanBeNull) {
                for (Object element : collection) {
                    kryo.writeObjectOrNull(output, element, elementSerializer);
                }
            } else {
                for (Object element : collection) {
                    kryo.writeObject(output, element, elementSerializer);
                }
            }
        } else {
            for (Object element : collection) {
                kryo.writeClassAndObject(output, element);
            }
        }
        kryo.getGenerics().popGenericType();
    }

    protected void writeHeader(Kryo kryo, Output output, T collection) {
    }

    protected T create(Kryo kryo, Input input, Class<? extends T> type, int size) {
        if (type == ArrayList.class) {
            return (T)new ArrayList(size);
        }
        Collection collection = (Collection)kryo.newInstance(type);
        if (collection instanceof ArrayList) {
            ((ArrayList)collection).ensureCapacity(size);
        }
        return (T)collection;
    }

    @Override
    public T read(Kryo kryo, Input input, Class<? extends T> type) {
        int i;
        T collection;
        int length;
        Class genericClass;
        Class elementClass = this.elementClass;
        Serializer elementSerializer = this.elementSerializer;
        if (elementSerializer == null && (genericClass = kryo.getGenerics().nextGenericClass()) != null && kryo.isFinal(genericClass)) {
            elementSerializer = kryo.getSerializer(genericClass);
            elementClass = genericClass;
        }
        boolean elementsCanBeNull = this.elementsCanBeNull;
        if (elementSerializer != null) {
            if (elementsCanBeNull) {
                elementsCanBeNull = input.readVarIntFlag();
                length = input.readVarIntFlag(true);
            } else {
                length = input.readVarInt(true);
            }
            if (length == 0) {
                return null;
            }
            collection = this.create(kryo, input, type, --length);
            kryo.reference(collection);
            if (length == 0) {
                return collection;
            }
        } else {
            boolean sameType = input.readVarIntFlag();
            length = input.readVarIntFlag(true);
            if (length == 0) {
                return null;
            }
            collection = this.create(kryo, input, type, --length);
            kryo.reference(collection);
            if (length == 0) {
                return collection;
            }
            if (sameType) {
                Registration registration = kryo.readClass(input);
                if (registration == null) {
                    for (int i2 = 0; i2 < length; ++i2) {
                        collection.add(null);
                    }
                    kryo.getGenerics().popGenericType();
                    return collection;
                }
                elementClass = registration.getType();
                elementSerializer = kryo.getSerializer(elementClass);
                if (elementsCanBeNull) {
                    elementsCanBeNull = input.readBoolean();
                }
            }
        }
        if (elementSerializer != null) {
            if (elementsCanBeNull) {
                for (i = 0; i < length; ++i) {
                    collection.add(kryo.readObjectOrNull(input, elementClass, elementSerializer));
                }
            } else {
                for (i = 0; i < length; ++i) {
                    collection.add(kryo.readObject(input, elementClass, elementSerializer));
                }
            }
        } else {
            for (i = 0; i < length; ++i) {
                collection.add((Object)kryo.readClassAndObject(input));
            }
        }
        kryo.getGenerics().popGenericType();
        return collection;
    }

    protected T createCopy(Kryo kryo, T original) {
        return (T)((Collection)kryo.newInstance(original.getClass()));
    }

    @Override
    public T copy(Kryo kryo, T original) {
        T copy = this.createCopy(kryo, original);
        kryo.reference(copy);
        for (Object element : original) {
            copy.add(kryo.copy(element));
        }
        return copy;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface BindCollection {
        public Class elementClass() default Object.class;

        public Class<? extends Serializer> elementSerializer() default Serializer.class;

        public Class<? extends SerializerFactory> elementSerializerFactory() default SerializerFactory.class;

        public boolean elementsCanBeNull() default true;
    }
}

