/*
 * Decompiled with CFR 0.152.
 */
package net.aeronica.mods.mxtune.world.caps.chunk;

import java.util.concurrent.Callable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.aeronica.mods.mxtune.network.PacketDispatcher;
import net.aeronica.mods.mxtune.network.client.UpdateChunkMusicData;
import net.aeronica.mods.mxtune.util.Miscellus;
import net.aeronica.mods.mxtune.util.NBTHelper;
import net.aeronica.mods.mxtune.world.caps.chunk.IModChunkPlaylist;
import net.aeronica.mods.mxtune.world.caps.chunk.ModChunkPlaylistHelper;
import net.aeronica.mods.mxtune.world.caps.chunk.ModChunkPlaylistImpl;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.world.ChunkWatchEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ModChunkPlaylistCap {
    @CapabilityInject(value=IModChunkPlaylist.class)
    private static final Capability<IModChunkPlaylist> MOD_CHUNK_DATA = (Capability)Miscellus.nonNullInjected();

    private ModChunkPlaylistCap() {
    }

    public static void register() {
        CapabilityManager.INSTANCE.register(IModChunkPlaylist.class, (Capability.IStorage)new Storage(), (Callable)new Factory());
        MinecraftForge.EVENT_BUS.register(ModChunkPlaylistCap.class);
    }

    @SubscribeEvent
    public static void onEvent(ChunkWatchEvent.Watch event) {
        EntityPlayerMP player = event.getPlayer();
        Chunk chunk = event.getChunkInstance();
        if (chunk != null && chunk.hasCapability(MOD_CHUNK_DATA, null)) {
            PacketDispatcher.sendTo(new UpdateChunkMusicData(chunk.func_76632_l().field_77276_a, chunk.func_76632_l().field_77275_b, ModChunkPlaylistHelper.getPlaylistGuid(chunk)), player);
        }
    }

    @SubscribeEvent
    public static void onEvent(AttachCapabilitiesEvent<Chunk> event) {
        if (event.getObject() != null) {
            event.addCapability(new ResourceLocation("mxtune", "chunk_music"), (ICapabilityProvider)new ICapabilitySerializable<NBTTagCompound>(){
                IModChunkPlaylist instance = (IModChunkPlaylist)ModChunkPlaylistCap.access$200().getDefaultInstance();

                public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
                    return capability == MOD_CHUNK_DATA;
                }

                @Nullable
                public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
                    return (T)(capability == MOD_CHUNK_DATA ? MOD_CHUNK_DATA.cast((Object)this.instance) : null);
                }

                public NBTTagCompound serializeNBT() {
                    return (NBTTagCompound)MOD_CHUNK_DATA.getStorage().writeNBT(MOD_CHUNK_DATA, (Object)this.instance, null);
                }

                public void deserializeNBT(NBTTagCompound nbt) {
                    MOD_CHUNK_DATA.getStorage().readNBT(MOD_CHUNK_DATA, (Object)this.instance, null, (NBTBase)nbt);
                }
            });
        }
    }

    private static class Storage
    implements Capability.IStorage<IModChunkPlaylist> {
        private Storage() {
        }

        @Nullable
        public NBTBase writeNBT(Capability<IModChunkPlaylist> capability, IModChunkPlaylist instance, EnumFacing side) {
            NBTTagCompound properties = new NBTTagCompound();
            NBTHelper.setGuidToCompound(properties, instance.getPlaylistGuid());
            return properties;
        }

        public void readNBT(Capability<IModChunkPlaylist> capability, IModChunkPlaylist instance, EnumFacing side, NBTBase nbt) {
            NBTTagCompound properties = (NBTTagCompound)nbt;
            instance.setPlaylistGuid(NBTHelper.getGuidFromCompound(properties));
        }
    }

    private static class Factory
    implements Callable<IModChunkPlaylist> {
        private Factory() {
        }

        @Override
        public IModChunkPlaylist call() {
            return new ModChunkPlaylistImpl();
        }
    }
}

