/*
 * Decompiled with CFR 0.152.
 */
package net.aeronica.mods.mxtune.util;

import javax.annotation.Nonnull;
import net.aeronica.libs.mml.parser.MMLParser;
import net.aeronica.libs.mml.parser.MMLParserFactory;
import net.aeronica.mods.mxtune.blocks.IMusicPlayer;
import net.aeronica.mods.mxtune.blocks.IPlacedInstrument;
import net.aeronica.mods.mxtune.blocks.TileInstrument;
import net.aeronica.mods.mxtune.init.ModItems;
import net.aeronica.mods.mxtune.inventory.IInstrument;
import net.aeronica.mods.mxtune.inventory.IMusic;
import net.aeronica.mods.mxtune.sound.MMLToMIDI;
import net.aeronica.mods.mxtune.sound.Midi2WavRenderer;
import net.aeronica.mods.mxtune.sound.ModMidiException;
import net.aeronica.mods.mxtune.util.ModLogger;
import net.aeronica.mods.mxtune.util.SheetMusicSongs;
import net.aeronica.mods.mxtune.util.ValidDuration;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;

public enum SheetMusicUtil {

    public static final String KEY_SHEET_MUSIC = "SheetMusic";
    public static final String KEY_DURATION = "Duration";
    public static final String KEY_MML = "MML";
    public static final String ITEM_INVENTORY = "ItemInventory";

    public static String getMusicTitle(ItemStack stackIn) {
        NBTTagCompound contents;
        ItemStack sheetMusic = SheetMusicUtil.getSheetMusic(stackIn);
        if (!sheetMusic.func_190926_b() && sheetMusic.func_77978_p() != null && !(contents = (NBTTagCompound)sheetMusic.func_77978_p().func_74781_a(KEY_SHEET_MUSIC)).func_82582_d()) {
            return sheetMusic.func_82833_r();
        }
        return "";
    }

    public static ItemStack getSheetMusic(BlockPos pos, EntityPlayer playerIn, boolean isPlaced) {
        if (isPlaced) {
            Block placedInst;
            Object te;
            if (playerIn.func_130014_f_().func_180495_p(pos).func_177230_c() instanceof IPlacedInstrument && !((TileInstrument)((Object)(te = ((IPlacedInstrument)(placedInst = playerIn.func_130014_f_().func_180495_p(pos).func_177230_c())).getTE(playerIn.func_130014_f_(), pos)))).getInventory().getStackInSlot(0).func_190926_b()) {
                return ((TileInstrument)((Object)te)).getInventory().getStackInSlot(0).func_77946_l();
            }
        } else {
            return SheetMusicUtil.getSheetMusic(playerIn.func_184614_ca());
        }
        return ItemStack.field_190927_a;
    }

    public static ItemStack getSheetMusic(ItemStack stackIn) {
        NBTTagCompound contents;
        NBTTagCompound item;
        ItemStack sheetMusic;
        NBTTagList items;
        if (stackIn.func_77973_b() instanceof IInstrument && stackIn.func_77978_p() != null && (items = stackIn.func_77978_p().func_150295_c(ITEM_INVENTORY, 10)).func_74745_c() == 1 && (sheetMusic = new ItemStack(item = items.func_150305_b(0))).func_77973_b() instanceof IMusic && sheetMusic.func_77978_p() != null && (contents = (NBTTagCompound)sheetMusic.func_77978_p().func_74781_a(KEY_SHEET_MUSIC)).func_74764_b(KEY_MML)) {
            return sheetMusic;
        }
        return ItemStack.field_190927_a;
    }

    public static boolean writeSheetMusic(ItemStack sheetMusic, @Nonnull String musicTitle, @Nonnull String mml) {
        sheetMusic.func_151001_c(musicTitle);
        NBTTagCompound compound = sheetMusic.func_77978_p();
        ValidDuration validDuration = SheetMusicUtil.validateMML(mml);
        if (compound != null && sheetMusic.func_77973_b() instanceof IMusic && validDuration.isValidMML().booleanValue() && validDuration.getDuration() > 0) {
            NBTTagCompound contents = new NBTTagCompound();
            contents.func_74778_a(KEY_MML, mml);
            contents.func_74768_a(KEY_DURATION, validDuration.getDuration().intValue());
            compound.func_74782_a(KEY_SHEET_MUSIC, (NBTBase)contents);
            return true;
        }
        return false;
    }

    public static ValidDuration validateMML(@Nonnull String mml) {
        int seconds = 0;
        MMLParser parser = MMLParserFactory.getMMLParser(mml);
        MMLToMIDI toMIDI = new MMLToMIDI();
        toMIDI.processMObjects(parser.getMmlObjects());
        try (Midi2WavRenderer midi2WavRenderer = new Midi2WavRenderer();){
            seconds = (int)(midi2WavRenderer.getSequenceInSeconds(toMIDI.getSequence()) + 4.0);
        }
        catch (ModMidiException e) {
            ModLogger.debug("ValidateMML Error: %s in %s", e, SheetMusicUtil.class.getSimpleName());
            return ValidDuration.INVALID;
        }
        ModLogger.debug("ValidateMML: length: %d", seconds);
        return new ValidDuration(seconds > 4, seconds);
    }

    public static String formatDuration(int seconds) {
        int absSeconds = Math.abs(seconds);
        String positive = String.format("%d:%02d:%02d", absSeconds / 3600, absSeconds % 3600 / 60, absSeconds % 60);
        return seconds < 0 ? "-" + positive : positive;
    }

    public static String getInventoryInstrumentBlockMML(TileEntity tileEntity) {
        if (!(tileEntity instanceof IMusicPlayer)) {
            return "";
        }
        StringBuilder buildMML = new StringBuilder();
        IMusicPlayer musicPlayer = (IMusicPlayer)tileEntity;
        for (int slot = 0; slot < musicPlayer.getInventory().getSlots(); ++slot) {
            NBTTagCompound contents;
            ItemStack stackInSlot = musicPlayer.getInventory().getStackInSlot(slot);
            if (stackInSlot.func_190926_b() || !(stackInSlot.func_77973_b() instanceof IInstrument)) continue;
            IInstrument instrument = (IInstrument)stackInSlot.func_77973_b();
            int patch = instrument.getPatch(stackInSlot);
            ItemStack sheetMusic = SheetMusicUtil.getSheetMusic(stackInSlot);
            if (sheetMusic.func_190926_b() || sheetMusic.func_77978_p() == null || !(contents = (NBTTagCompound)sheetMusic.func_77978_p().func_74781_a(KEY_SHEET_MUSIC)).func_74764_b(KEY_MML)) continue;
            String mml = contents.func_74779_i(KEY_MML);
            mml = mml.replace("MML@", "MML@I" + patch);
            buildMML.append(mml);
        }
        return buildMML.toString();
    }

    public static ItemStack createSheetMusic(String title, String mml) {
        ItemStack sheetMusic = new ItemStack((Item)ModItems.ITEM_SHEET_MUSIC);
        if (SheetMusicUtil.writeSheetMusic(sheetMusic, title, mml)) {
            return sheetMusic;
        }
        return new ItemStack((Item)ModItems.ITEM_MUSIC_PAPER);
    }

    public static ItemStack createSheetMusic(SheetMusicSongs sheetMusicSong) {
        return SheetMusicUtil.createSheetMusic(sheetMusicSong.getTitle(), sheetMusicSong.getMML());
    }
}

