/*
 * Decompiled with CFR 0.152.
 */
package net.aeronica.mods.mxtune.util;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.sun.media.sound.AudioSynthesizer;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.sound.midi.Instrument;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Patch;
import javax.sound.midi.Soundbank;
import javax.sound.midi.Synthesizer;
import net.aeronica.libs.mml.parser.MMLUtil;
import net.aeronica.mods.mxtune.MXTune;
import net.aeronica.mods.mxtune.config.ModConfig;
import net.aeronica.mods.mxtune.util.ModLogger;
import net.aeronica.mods.mxtune.util.NullInstrument;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public enum MIDISystemUtil {

    private static final String NO_SOUND_BANK = I18n.func_135052_a((String)"mxtune.msu.no_sound_bank_loaded", (Object[])new Object[0]);
    private static MidiDevice.Info bestSynthInfo = null;
    private static Synthesizer bestSynth = null;
    private static Soundbank mxTuneSoundBank = null;
    private static boolean synthAvailable = false;
    private static boolean soundBankAvailable = false;
    private static boolean midiAvailable = false;
    private static int timesToWarn = 10;
    private static final List<TextComponentString> chatStatus = new ArrayList<TextComponentString>();
    private static final ResourceLocation SOUND_FONT = new ResourceLocation("mxtune", "synth/mxtune_v2.sf2");
    private static final List<Instrument> instrumentCache = new ArrayList<Instrument>();
    private static final BiMap<Integer, Integer> packedPresetToInstrumentCacheIndex = HashBiMap.create();
    private static BiMap<Integer, Integer> instrumentCacheIndexToPackedPreset;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void mxTuneInit() {
        MidiDevice.Info[] midiDeviceInfo = MidiSystem.getMidiDeviceInfo();
        ArrayList<MidiDevice.Info> synthInfos = new ArrayList<MidiDevice.Info>();
        MidiDevice device = null;
        int maxPolyphony = 0;
        AudioSynthesizer testSynth = null;
        chatStatus.clear();
        for (MidiDevice.Info aMidiDeviceInfo : midiDeviceInfo) {
            try {
                device = MidiSystem.getMidiDevice(aMidiDeviceInfo);
            }
            catch (MidiUnavailableException e) {
                ModLogger.error(e);
                midiAvailable = false;
            }
            finally {
                if (device != null) {
                    device.close();
                }
            }
            if (!(device instanceof AudioSynthesizer)) continue;
            synthInfos.add(aMidiDeviceInfo);
            synthAvailable = true;
        }
        for (MidiDevice.Info info : synthInfos) {
            ModLogger.info(info.getName(), new Object[0]);
            ModLogger.info(info.getDescription(), new Object[0]);
            ModLogger.info(info.getVendor(), new Object[0]);
            ModLogger.info(info.getVersion(), new Object[0]);
            try {
                testSynth = (AudioSynthesizer)MidiSystem.getMidiDevice(info);
            }
            catch (MidiUnavailableException e) {
                ModLogger.error(e);
                synthAvailable = false;
            }
            finally {
                if (synthAvailable && testSynth != null && testSynth.getMaxPolyphony() > maxPolyphony) {
                    maxPolyphony = testSynth.getMaxPolyphony();
                    bestSynthInfo = info;
                    bestSynth = testSynth;
                }
                if (testSynth == null) continue;
                testSynth.close();
            }
        }
        if (bestSynth != null && synthAvailable) {
            try {
                mxTuneSoundBank = MidiSystem.getSoundbank(MIDISystemUtil.getMXTuneSoundBankURL());
            }
            catch (IOException | InvalidMidiDataException e) {
                ModLogger.error(e);
                mxTuneSoundBank = null;
            }
            if (mxTuneSoundBank != null) {
                Instrument[] inst = mxTuneSoundBank.getInstruments();
                soundBankAvailable = !mxTuneSoundBank.getName().isEmpty();
                ModLogger.info("--- " + (mxTuneSoundBank.getName().isEmpty() ? "*No Name*" : mxTuneSoundBank.getName()) + " ---", new Object[0]);
                ModLogger.info("Number of instruments: " + inst.length, new Object[0]);
                for (Instrument i : inst) {
                    ModLogger.info("(%5d, %3d) %s", i.getPatch().getBank(), i.getPatch().getProgram(), i.getName());
                }
            }
        }
        if (bestSynth != null && synthAvailable && soundBankAvailable) {
            ModLogger.info(bestSynthInfo.getName(), new Object[0]);
            ModLogger.info(bestSynthInfo.getDescription(), new Object[0]);
            ModLogger.info(bestSynthInfo.getVendor(), new Object[0]);
            ModLogger.info(bestSynthInfo.getVersion(), new Object[0]);
            ModLogger.info("MaxPolyphony: " + bestSynth.getMaxPolyphony() + ", MaxReceivers: " + (bestSynth.getMaxReceivers() == -1 ? "Unlimited" : Integer.valueOf(bestSynth.getMaxReceivers())), new Object[0]);
            ModLogger.info("Synthsizer Available: ?         " + synthAvailable, new Object[0]);
            ModLogger.info("Default Sound Bank Available: ? " + soundBankAvailable, new Object[0]);
            MIDISystemUtil.addStatus(new TextComponentString("[mxTune] " + TextFormatting.GREEN + I18n.func_135052_a((String)"mxtune.chat.msu.midiAvailable", (Object[])new Object[0])));
            midiAvailable = true;
        } else {
            ModLogger.error("WARNING - Default Synthesizer available? : " + synthAvailable, new Object[0]);
            ModLogger.error("WARNING - Default Sound Bank available?  : " + soundBankAvailable, new Object[0]);
            ModLogger.error("WARNING - MIDI System is missing resources! mxTune cannot function properly!", new Object[0]);
            MIDISystemUtil.addStatus(new TextComponentString("[mxTune] " + TextFormatting.RED + I18n.func_135052_a((String)"mxtune.chat.msu.midiNotAvailable", (Object[])new Object[0])));
            MIDISystemUtil.addStatus(new TextComponentString("[mxTune] " + TextFormatting.YELLOW + I18n.func_135052_a((String)"mxtune.chat.msu.suggestion.01", (Object[])new Object[0])));
            MIDISystemUtil.addStatus(new TextComponentString("[mxTune] " + TextFormatting.YELLOW + I18n.func_135052_a((String)"mxtune.chat.msu.suggestion.02", (Object[])new Object[0])));
            midiAvailable = false;
        }
        MIDISystemUtil.initInstrumentCache();
    }

    private static void addStatus(TextComponentString status) {
        chatStatus.add(status);
    }

    public static boolean midiUnavailable() {
        return !midiAvailable;
    }

    public static boolean midiUnavailableWarn(EntityPlayer playerIn) {
        boolean unAvailable = MIDISystemUtil.midiUnavailable();
        if (unAvailable && timesToWarn-- > 0) {
            MIDISystemUtil.onPlayerLoggedInModStatus(playerIn);
        }
        return unAvailable;
    }

    public static void onPlayerLoggedInModStatus(EntityPlayer playerIn) {
        if (ModConfig.showWelcomeStatusMessage()) {
            for (TextComponentString tcs : chatStatus) {
                playerIn.func_145747_a((ITextComponent)tcs);
            }
        }
    }

    private static URL getMXTuneSoundBankURL() {
        URL file = MXTune.class.getResource("/assets/" + SOUND_FONT.func_110624_b() + "/" + SOUND_FONT.func_110623_a());
        ModLogger.info("Sound font path: %s", file);
        return file;
    }

    public static Soundbank getMXTuneSoundBank() {
        return mxTuneSoundBank;
    }

    private static NullInstrument getNullInstrument() {
        return new NullInstrument(null, new Patch(0, 0), NO_SOUND_BANK, NullClass.class);
    }

    private static void initInstrumentCache() {
        if (MIDISystemUtil.midiUnavailable() || mxTuneSoundBank == null) {
            instrumentCache.add(MIDISystemUtil.getNullInstrument());
        } else {
            Collections.addAll(instrumentCache, mxTuneSoundBank.getInstruments());
        }
        int index = 0;
        for (Instrument instrument : instrumentCache) {
            int packedPreset = MMLUtil.instrument2PackedPreset(instrument);
            packedPresetToInstrumentCacheIndex.put((Object)packedPreset, (Object)index++);
        }
        instrumentCacheIndexToPackedPreset = packedPresetToInstrumentCacheIndex.inverse();
    }

    public static List<Instrument> getInstrumentCacheCopy() {
        return new ArrayList<Instrument>(instrumentCache);
    }

    public static int getPackedPresetFromInstrumentCacheIndex(int index) {
        int packedPreset;
        try {
            packedPreset = (Integer)instrumentCacheIndexToPackedPreset.get((Object)index);
        }
        catch (ClassCastException | NullPointerException e) {
            packedPreset = 0;
        }
        return packedPreset;
    }

    public static int getInstrumentCachedIndexFromPackedPreset(int packedPatch) {
        int cacheIndex;
        try {
            cacheIndex = (Integer)packedPresetToInstrumentCacheIndex.get((Object)packedPatch);
        }
        catch (ClassCastException | NullPointerException e) {
            cacheIndex = 0;
        }
        return cacheIndex;
    }

    public static String getPatchNameKey(Patch patch) {
        for (Instrument inst : instrumentCache) {
            if ((!inst.toString().contains("Drumkit:") || inst.getPatch().getProgram() != patch.getProgram()) && (inst.getPatch().getBank() / 128 != patch.getBank() || inst.getPatch().getProgram() != patch.getProgram())) continue;
            return inst.getName();
        }
        return "--- Error ---";
    }

    private class NullClass {
        private int someInt;

        NullClass() {
            this.someInt = 0;
        }

        NullClass(int someInt) {
            this.someInt = someInt;
        }

        public int getSomeInt() {
            return this.someInt;
        }
    }
}

