/*
 * Decompiled with CFR 0.152.
 */
package net.aeronica.mods.mxtune.util;

import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import javax.annotation.Nullable;
import net.aeronica.mods.mxtune.util.CallBack;
import net.aeronica.mods.mxtune.util.Notify;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;

public class CallBackManager {
    private static Timer timer;
    private static Map<UUID, CallBack> callbacks;
    private static Map<UUID, TimerTask> tasks;
    private static Map<UUID, Notify> notified;

    private CallBackManager() {
    }

    public static void start() {
        if (timer == null) {
            timer = new Timer("mxTune CallBackManager Timer");
        }
    }

    public static void shutdown() {
        if (timer != null) {
            timer.purge();
            timer.cancel();
            timer = null;
        }
        callbacks.clear();
        tasks.clear();
        notified.clear();
    }

    public static UUID register(CallBack callBack) {
        return CallBackManager.register(callBack, 30);
    }

    public static UUID register(CallBack callback, int timeout) {
        UUID uuid = UUID.randomUUID();
        if (timer != null) {
            callbacks.put(uuid, callback);
            CallBackManager.scheduleTimeout(uuid, callback, timeout);
        }
        return uuid;
    }

    public static UUID register(CallBack callBack, Notify notify) {
        UUID uuid = CallBackManager.register(callBack, 30);
        notified.put(uuid, notify);
        return uuid;
    }

    public static synchronized void cancel(UUID uuid) {
        callbacks.remove(uuid);
        tasks.get(uuid).cancel();
        tasks.remove(uuid);
    }

    private static void scheduleTimeout(final UUID uuid, final CallBack callBack, final int timeout) {
        if (timer != null) {
            TimerTask task = new TimerTask(){

                @Override
                public void run() {
                    CallBackManager.timedOut(uuid, callBack, timeout);
                }
            };
            tasks.put(uuid, task);
            long delay = (long)timeout * 1000L;
            timer.schedule(task, delay);
        }
    }

    @Nullable
    public static synchronized CallBack getCaller(UUID uuid) {
        if (callbacks.containsKey(uuid)) {
            CallBack callBack = callbacks.get(uuid);
            CallBackManager.cancel(uuid);
            return callBack;
        }
        return null;
    }

    @Nullable
    public static synchronized Notify getNotified(UUID uuid) {
        Notify notify = notified.get(uuid);
        notified.remove(uuid);
        return notify;
    }

    private static synchronized void timedOut(UUID uuid, CallBack callBack, int timeout) {
        callbacks.remove(uuid);
        notified.remove(uuid);
        tasks.remove(uuid);
        callBack.onFailure((ITextComponent)new TextComponentTranslation("mxtune.error.network_timeout", new Object[]{timeout}));
    }

    static {
        callbacks = new HashMap<UUID, CallBack>();
        tasks = new HashMap<UUID, TimerTask>();
        notified = new HashMap<UUID, Notify>();
    }
}

