/*
 * Decompiled with CFR 0.152.
 */
package net.aeronica.mods.mxtune.status;

import java.util.HashMap;
import java.util.Map;
import net.aeronica.mods.mxtune.managers.ServerFileManager;
import net.aeronica.mods.mxtune.network.PacketDispatcher;
import net.aeronica.mods.mxtune.network.bidirectional.ClientStateDataMessage;
import net.aeronica.mods.mxtune.network.client.SendCSDChatMessage;
import net.aeronica.mods.mxtune.status.ClientStateData;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;

public class ServerCSDManager {
    private static Map<Integer, ClientStateData> clientState = new HashMap<Integer, ClientStateData>();

    private ServerCSDManager() {
    }

    public static void queryClient(EntityPlayer playerIn) {
        ClientStateDataMessage message = new ClientStateDataMessage(ServerFileManager.getServerID());
        PacketDispatcher.sendTo(message, (EntityPlayerMP)playerIn);
    }

    public static void updateState(EntityPlayer playerIn, ClientStateData csd) {
        Integer playerID = playerIn.func_145782_y();
        if (clientState.containsKey(playerID)) {
            clientState.replace(playerID, csd);
        } else {
            clientState.put(playerID, csd);
        }
    }

    private static boolean canMXTunesPlay(Integer playerID) {
        return clientState.containsKey(playerID) && clientState.get(playerID).isGood();
    }

    public static boolean canMXTunesPlay(EntityPlayer playerIn) {
        return ServerCSDManager.canMXTunesPlay(playerIn.func_145782_y());
    }

    public static void sendErrorViaChat(EntityPlayer playerIn) {
        Integer playerID = playerIn.func_145782_y();
        if (clientState.containsKey(playerID)) {
            SendCSDChatMessage message = new SendCSDChatMessage(clientState.get(playerID));
            PacketDispatcher.sendTo(message, (EntityPlayerMP)playerIn);
        }
    }
}

