/*
 * Decompiled with CFR 0.152.
 */
package net.aeronica.mods.mxtune.sound;

import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Patch;
import javax.sound.sampled.AudioInputStream;
import net.aeronica.libs.mml.parser.MMLParser;
import net.aeronica.libs.mml.parser.MMLParserFactory;
import net.aeronica.libs.mml.parser.MMLUtil;
import net.aeronica.mods.mxtune.sound.AudioData;
import net.aeronica.mods.mxtune.sound.ClientAudio;
import net.aeronica.mods.mxtune.sound.MMLToMIDI;
import net.aeronica.mods.mxtune.sound.Midi2WavRenderer;
import net.aeronica.mods.mxtune.sound.ModMidiException;
import net.aeronica.mods.mxtune.util.ModLogger;
import net.aeronica.mods.mxtune.util.SoundFontProxyManager;
import net.minecraft.client.resources.I18n;

public class MML2PCM {
    private final AudioData audioData;
    private final String mmlText;

    MML2PCM(AudioData audioData, String mmlText) {
        this.audioData = audioData;
        this.mmlText = mmlText;
    }

    public boolean process() {
        MMLParser mmlParser = MMLParserFactory.getMMLParser(this.mmlText);
        MMLToMIDI toMIDI = new MMLToMIDI();
        toMIDI.processMObjects(mmlParser.getMmlObjects());
        for (int preset : toMIDI.getPresets()) {
            Patch patchPreset = MMLUtil.packedPreset2Patch(SoundFontProxyManager.getPackedPreset(preset));
            String name = I18n.func_135052_a((String)SoundFontProxyManager.getLangKeyName(preset), (Object[])new Object[0]);
            ModLogger.debug("MML2PCM preset: %3d, bank: %3d, program: %3d, name: %s", preset, patchPreset.getBank(), patchPreset.getProgram(), name);
        }
        try {
            Midi2WavRenderer mw = new Midi2WavRenderer();
            AudioInputStream pcmStream = mw.createPCMStream(toMIDI.getSequence(), this.audioData.getAudioFormat());
            this.audioData.setAudioStream(pcmStream);
        }
        catch (MidiUnavailableException | ModMidiException e) {
            this.audioData.setStatus(ClientAudio.Status.ERROR);
            ModLogger.error("MIDI to PCM process: ", e);
            return false;
        }
        this.audioData.setStatus(ClientAudio.Status.READY);
        return true;
    }
}

