/*
 * Decompiled with CFR 0.152.
 */
package net.aeronica.mods.mxtune.sound;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ShortBuffer;
import java.util.Random;
import javax.annotation.Nullable;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import net.aeronica.mods.mxtune.sound.AudioData;
import net.aeronica.mods.mxtune.sound.ClientAudio;
import net.aeronica.mods.mxtune.util.Miscellus;
import paulscode.sound.ICodec;
import paulscode.sound.SoundBuffer;
import paulscode.sound.SoundSystemConfig;
import paulscode.sound.SoundSystemLogger;

public class CodecPCM
implements ICodec {
    private static final boolean GET = false;
    private static final boolean SET = true;
    private static final boolean XXX = false;
    private boolean endOfStream = false;
    private boolean initialized = false;
    private AudioFormat myAudioFormat = null;
    private boolean reverseBytes = false;
    private AudioInputStream audioInputStream = null;
    private AudioInputStream dummyInputStream = null;
    private static final int SAMPLE_SIZE = 44100;
    private final byte[] noiseBuffer = new byte[44100];
    private final byte[] zeroBuffer = new byte[44100];
    private boolean hasStream = false;
    private int zeroBufferCount = 0;
    private final Random randInt;
    private Integer playID = null;
    private AudioData audioData = null;
    private final SoundSystemLogger logger = SoundSystemConfig.getLogger();

    public CodecPCM() {
        this.randInt = new Random(System.currentTimeMillis());
        this.nextNoiseZeroBuffer();
    }

    private void nextNoiseZeroBuffer() {
        for (int i = 0; i < 44100; i += 2) {
            int x = (short)(this.randInt.nextInt() / 3) * 2;
            this.noiseBuffer[i] = (byte)x;
            this.noiseBuffer[i + 1] = (byte)(x >> 8);
            this.zeroBuffer[i + 1] = 0;
            this.zeroBuffer[i] = 0;
        }
    }

    public void reverseByteOrder(boolean b) {
        this.reverseBytes = b;
    }

    public boolean initialize(@Nullable URL url) {
        this.initialized(true, false);
        if (this.playID == null) {
            this.playID = ClientAudio.pollPlayIDQueuePCM();
            if (this.playID == null || this.playID == -1) {
                this.errorMessage("playID not initialized");
                return false;
            }
            try {
                this.audioData = ClientAudio.getAudioData(this.playID);
                this.myAudioFormat = this.audioData.getAudioFormat();
            }
            catch (Exception e) {
                this.errorMessage("AudioData instance for playID does not exist!");
                this.cleanup();
                this.printStackTrace(e);
                return false;
            }
        }
        if (url == null) {
            this.errorMessage("url null in method 'initialize'");
            this.cleanup();
            this.audioDataSetStatus(ClientAudio.Status.ERROR);
            return false;
        }
        try {
            this.dummyInputStream = AudioSystem.getAudioInputStream(new BufferedInputStream(url.openStream()));
        }
        catch (UnsupportedAudioFileException uafe) {
            this.errorMessage("Unsupported audio format in method 'initialize'");
            this.printStackTrace(uafe);
            this.cleanup();
            this.audioDataSetStatus(ClientAudio.Status.ERROR);
            return false;
        }
        catch (IOException ioe) {
            this.errorMessage("Error setting up audio input stream in method 'initialize'");
            this.printStackTrace(ioe);
            this.cleanup();
            this.audioDataSetStatus(ClientAudio.Status.ERROR);
            return false;
        }
        this.endOfStream(true, false);
        this.initialized(true, true);
        return true;
    }

    public boolean initialized() {
        return this.initialized(false, false);
    }

    @Nullable
    public SoundBuffer read() {
        if (this.hasInputStreamError()) {
            this.errorMessage("Not initialized in 'read'");
            return null;
        }
        this.notifyOnInputStreamAvailable();
        byte[] readBuffer = new byte[SoundSystemConfig.getStreamingBufferSize()];
        byte[] outputBuffer = new byte[]{};
        try {
            if (this.hasStream && this.audioInputStream != null) {
                int bufferSize = this.audioInputStream.read(readBuffer);
                if (bufferSize > 0) {
                    outputBuffer = Miscellus.appendByteArrays(outputBuffer, readBuffer, bufferSize);
                }
                if (bufferSize == -1) {
                    this.endOfStream(true, true);
                    this.audioDataSetStatus(ClientAudio.Status.DONE);
                    return null;
                }
            } else {
                this.nextNoiseZeroBuffer();
                outputBuffer = Miscellus.appendByteArrays(outputBuffer, this.zeroBuffer, 44100);
                if (this.zeroBufferCount++ > 64) {
                    this.errorMessage("MML to PCM audio processing took too long. Aborting!");
                    this.endOfStream(true, true);
                    this.audioDataSetStatus(ClientAudio.Status.ERROR);
                    return null;
                }
            }
        }
        catch (IOException e) {
            this.printStackTrace(e);
            this.endOfStream(true, true);
            this.audioDataSetStatus(ClientAudio.Status.ERROR);
            return null;
        }
        if (!this.reverseBytes && outputBuffer.length > 0) {
            CodecPCM.reverseBytes(outputBuffer, 0, outputBuffer.length);
        }
        return new SoundBuffer(outputBuffer, this.myAudioFormat);
    }

    private boolean hasInputStreamError() {
        if (!this.initialized || this.myAudioFormat == null || this.audioData == null || this.audioData.getStatus() == ClientAudio.Status.ERROR) {
            this.errorMessage("Not initialized in 'read'");
            return true;
        }
        return false;
    }

    private void notifyOnInputStreamAvailable() {
        if (!this.hasStream && this.audioData.getStatus() == ClientAudio.Status.READY) {
            this.audioInputStream = this.audioData.getAudioStream();
            try {
                if (this.audioInputStream.available() > 0) {
                    this.hasStream = true;
                }
            }
            catch (IOException e) {
                this.errorMessage("audioInputStream error");
                this.audioDataSetStatus(ClientAudio.Status.ERROR);
            }
        }
    }

    private void audioDataSetStatus(ClientAudio.Status status) {
        if (this.audioData != null) {
            this.audioData.setStatus(status);
        }
    }

    @Nullable
    public SoundBuffer readAll() {
        if (!this.initialized) {
            this.errorMessage("Not initialized in 'readAll'");
            return null;
        }
        if (this.myAudioFormat == null || this.audioData == null || this.audioData.getStatus() == ClientAudio.Status.ERROR) {
            this.errorMessage("Audio Format null in method 'readAll'");
            return null;
        }
        if (this.endOfStream()) {
            return null;
        }
        byte[] outputBuffer = null;
        for (int i = 0; i < 25; ++i) {
            this.nextNoiseZeroBuffer();
            outputBuffer = Miscellus.appendByteArrays(outputBuffer, this.noiseBuffer, 44100);
        }
        this.errorMessage("ReadAll NOT Supported! Always use stream = true. You have been warned.");
        if (!this.reverseBytes) {
            CodecPCM.reverseBytes(outputBuffer, 0, outputBuffer.length);
        }
        return new SoundBuffer(outputBuffer, this.myAudioFormat);
    }

    public boolean endOfStream() {
        return this.endOfStream(false, false);
    }

    public void cleanup() {
        if (this.audioInputStream != null) {
            try {
                this.audioInputStream.close();
            }
            catch (IOException e) {
                this.printStackTrace(e);
            }
        }
        this.audioInputStream = null;
        if (this.dummyInputStream != null) {
            try {
                this.dummyInputStream.close();
            }
            catch (Exception e) {
                this.printStackTrace(e);
            }
        }
        this.dummyInputStream = null;
    }

    public AudioFormat getAudioFormat() {
        return this.myAudioFormat;
    }

    private synchronized boolean initialized(boolean action, boolean value) {
        if (action) {
            this.initialized = value;
        }
        return this.initialized;
    }

    private synchronized boolean endOfStream(boolean action, boolean value) {
        if (action) {
            this.endOfStream = value;
        }
        return this.endOfStream;
    }

    @Nullable
    private static byte[] trimArray(@Nullable byte[] array, int maxLength) {
        byte[] trimmedArray = null;
        if (array != null && array.length > maxLength) {
            trimmedArray = new byte[maxLength];
            System.arraycopy(array, 0, trimmedArray, 0, maxLength);
        }
        return trimmedArray;
    }

    public static void reverseBytes(byte[] buffer) {
        CodecPCM.reverseBytes(buffer, 0, buffer.length);
    }

    private static void reverseBytes(byte[] buffer, int offset, int size) {
        for (int i = offset; i < offset + size; i += 2) {
            byte b = buffer[i];
            buffer[i] = buffer[i + 1];
            buffer[i + 1] = b;
        }
    }

    private static byte[] convertAudioBytes(byte[] audioBytes, boolean twoBytesData) {
        ByteBuffer dest = ByteBuffer.allocateDirect(audioBytes.length);
        dest.order(ByteOrder.nativeOrder());
        ByteBuffer src = ByteBuffer.wrap(audioBytes);
        src.order(ByteOrder.LITTLE_ENDIAN);
        if (twoBytesData) {
            ShortBuffer destShort = dest.asShortBuffer();
            ShortBuffer srcShort = src.asShortBuffer();
            while (srcShort.hasRemaining()) {
                destShort.put(srcShort.get());
            }
        } else {
            while (src.hasRemaining()) {
                dest.put(src.get());
            }
        }
        dest.rewind();
        if (!dest.hasArray()) {
            byte[] arrayBackedBuffer = new byte[dest.capacity()];
            dest.get(arrayBackedBuffer);
            dest.clear();
            return arrayBackedBuffer;
        }
        return dest.array();
    }

    private void errorMessage(String message) {
        this.logger.errorMessage("[mxtune] CodecPCM", message, 1);
    }

    private void printStackTrace(Exception e) {
        this.logger.printStackTrace(e, 1);
    }

    private void message(String message) {
        this.logger.message("[mxtune]: CodecPCM " + message, 1);
    }
}

