/*
 * Decompiled with CFR 0.152.
 */
package net.aeronica.mods.mxtune.proxy;

import com.google.common.util.concurrent.ListenableFuture;
import javax.annotation.Nullable;
import net.aeronica.mods.mxtune.entity.EntityTimpaniFx;
import net.aeronica.mods.mxtune.entity.living.EntityGoldenSkeleton;
import net.aeronica.mods.mxtune.entity.living.EntityTimpani;
import net.aeronica.mods.mxtune.gui.hud.GuiJamOverlay;
import net.aeronica.mods.mxtune.gui.mml.GuiStaffOverlay;
import net.aeronica.mods.mxtune.handler.KeyHandler;
import net.aeronica.mods.mxtune.managers.ClientFileManager;
import net.aeronica.mods.mxtune.managers.ClientPlayManager;
import net.aeronica.mods.mxtune.model.ModelLoader;
import net.aeronica.mods.mxtune.network.MultiPacketSerializedObjectManager;
import net.aeronica.mods.mxtune.proxy.ServerProxy;
import net.aeronica.mods.mxtune.render.RenderGoldenSkeleton;
import net.aeronica.mods.mxtune.render.RenderTimpani;
import net.aeronica.mods.mxtune.sound.ClientAudio;
import net.aeronica.mods.mxtune.util.CallBackManager;
import net.aeronica.mods.mxtune.util.MIDISystemUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.util.IThreadListener;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class ClientProxy
extends ServerProxy {
    @Override
    public void preInit() {
        ModelLoaderRegistry.registerLoader((ICustomModelLoader)ModelLoader.INSTANCE);
        RenderingRegistry.registerEntityRenderingHandler(EntityGoldenSkeleton.class, RenderGoldenSkeleton.FACTORY);
        RenderingRegistry.registerEntityRenderingHandler(EntityTimpani.class, RenderTimpani.FACTORY);
    }

    @Override
    public void init() {
    }

    @Override
    public void postInit() {
    }

    @Override
    public void initEntities() {
        super.initEntities();
    }

    @Override
    public ListenableFuture<Object> addScheduledTask(Runnable runnableToSchedule) {
        return Minecraft.func_71410_x().func_152344_a(runnableToSchedule);
    }

    @Override
    public Side getPhysicalSide() {
        return Side.CLIENT;
    }

    @Override
    public Side getEffectiveSide() {
        return FMLCommonHandler.instance().getEffectiveSide();
    }

    @Override
    public Minecraft getMinecraft() {
        return Minecraft.func_71410_x();
    }

    @Override
    public EntityPlayer getClientPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    @Override
    @Nullable
    public EntityPlayer getPlayerByEntityID(int entityID) {
        return (EntityPlayer)this.getClientPlayer().func_130014_f_().func_73045_a(entityID);
    }

    public WorldClient getClientWorld() {
        return Minecraft.func_71410_x().field_71441_e;
    }

    @Override
    public void spawnMusicParticles(EntityPlayer player) {
    }

    @Override
    public void registerEventHandlers() {
        super.registerEventHandlers();
    }

    @Override
    public void registerKeyBindings() {
        MinecraftForge.EVENT_BUS.register((Object)KeyHandler.getInstance());
    }

    @Override
    public void initMML() {
        MIDISystemUtil.mxTuneInit();
        ((IReloadableResourceManager)this.getMinecraft().func_110442_L()).func_110542_a((IResourceManagerReloadListener)ClientAudio.INSTANCE);
    }

    @Override
    public void registerHUD() {
        MinecraftForge.EVENT_BUS.register((Object)GuiJamOverlay.getInstance());
        MinecraftForge.EVENT_BUS.register((Object)GuiStaffOverlay.getInstance());
    }

    @Override
    public boolean playerIsInCreativeMode(EntityPlayer player) {
        if (player instanceof EntityPlayerMP) {
            EntityPlayerMP entityPlayerMP = (EntityPlayerMP)player;
            return entityPlayerMP.func_184812_l_();
        }
        if (player instanceof EntityPlayerSP) {
            return Minecraft.func_71410_x().field_71442_b.func_78758_h();
        }
        return false;
    }

    @Override
    public EntityPlayer getPlayerEntity(MessageContext ctx) {
        return ctx.side.isClient() ? this.getClientPlayer() : super.getPlayerEntity(ctx);
    }

    @Override
    public IThreadListener getThreadFromContext(MessageContext ctx) {
        return ctx.side.isClient() ? this.getMinecraft() : super.getThreadFromContext(ctx);
    }

    @Override
    public void clientConnect(FMLNetworkEvent.ClientConnectedToServerEvent event) {
        CallBackManager.start();
        ClientPlayManager.reset();
    }

    @Override
    public void clientDisconnect(FMLNetworkEvent.ClientDisconnectionFromServerEvent event) {
        CallBackManager.shutdown();
        ClientFileManager.clearCache();
        MultiPacketSerializedObjectManager.shutdown();
    }

    @Override
    public void spawnTimpaniParticle(World world, double x, double y, double z) {
        Item item = world.func_180494_b(new BlockPos(x, y, z)).func_150559_j() ? Items.field_151126_ay : Items.field_151083_be;
        Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)new EntityTimpaniFx(world, x, y, z, item, item.func_77647_b(0)));
    }
}

