/*
 * Decompiled with CFR 0.152.
 */
package net.aeronica.mods.mxtune.network.server;

import net.aeronica.mods.mxtune.network.AbstractMessage;
import net.aeronica.mods.mxtune.options.MusicOptionsUtil;
import net.aeronica.mods.mxtune.util.GUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.relauncher.Side;

public class PlayerSelectedPlayListMessage
extends AbstractMessage.AbstractServerMessage<PlayerSelectedPlayListMessage> {
    private GUID selectedAreaGuid;
    private long ddddSigBits;
    private long ccccSigBits;
    private long bbbbSigBits;
    private long aaaaSigBits;

    public PlayerSelectedPlayListMessage() {
    }

    public PlayerSelectedPlayListMessage(GUID selectedAreaGuid) {
        this.ddddSigBits = selectedAreaGuid.getDdddSignificantBits();
        this.ccccSigBits = selectedAreaGuid.getCcccSignificantBits();
        this.bbbbSigBits = selectedAreaGuid.getBbbbSignificantBits();
        this.aaaaSigBits = selectedAreaGuid.getAaaaSignificantBits();
    }

    @Override
    protected void read(PacketBuffer buffer) {
        this.ddddSigBits = buffer.readLong();
        this.ccccSigBits = buffer.readLong();
        this.bbbbSigBits = buffer.readLong();
        this.aaaaSigBits = buffer.readLong();
        this.selectedAreaGuid = new GUID(this.ddddSigBits, this.ccccSigBits, this.bbbbSigBits, this.aaaaSigBits);
    }

    @Override
    protected void write(PacketBuffer buffer) {
        buffer.writeLong(this.ddddSigBits);
        buffer.writeLong(this.ccccSigBits);
        buffer.writeLong(this.bbbbSigBits);
        buffer.writeLong(this.aaaaSigBits);
    }

    @Override
    public void process(EntityPlayer player, Side side) {
        MusicOptionsUtil.setSelectedPlayListGuid(player, this.selectedAreaGuid);
    }
}

