/*
 * Decompiled with CFR 0.152.
 */
package net.aeronica.mods.mxtune.network.server;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import net.aeronica.mods.mxtune.network.AbstractMessage;
import net.aeronica.mods.mxtune.options.ClassifiedPlayer;
import net.aeronica.mods.mxtune.options.MusicOptionsUtil;
import net.aeronica.mods.mxtune.util.ModLogger;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.relauncher.Side;

public class MusicOptionsMessage
extends AbstractMessage.AbstractServerMessage<MusicOptionsMessage> {
    private int muteOption;
    private List<ClassifiedPlayer> blackList;
    private List<ClassifiedPlayer> whiteList;
    private byte[] byteBuffer = null;
    private boolean canProcess = true;

    public MusicOptionsMessage() {
    }

    public MusicOptionsMessage(int muteOption, List<ClassifiedPlayer> blackList, List<ClassifiedPlayer> whiteList) {
        this.muteOption = muteOption;
        this.blackList = blackList;
        this.whiteList = whiteList;
    }

    @Override
    protected void read(PacketBuffer buffer) {
        this.muteOption = buffer.readInt();
        try {
            this.byteBuffer = buffer.func_179251_a();
            ByteArrayInputStream bis = new ByteArrayInputStream(this.byteBuffer);
            ObjectInputStream in = new ObjectInputStream(bis);
            this.whiteList = (ArrayList)in.readObject();
            in.close();
            this.byteBuffer = buffer.func_179251_a();
            bis = new ByteArrayInputStream(this.byteBuffer);
            in = new ObjectInputStream(bis);
            this.blackList = (ArrayList)in.readObject();
            in.close();
        }
        catch (IOException | ClassNotFoundException e) {
            this.canProcess = false;
            ModLogger.error(e);
        }
    }

    @Override
    protected void write(PacketBuffer buffer) {
        buffer.writeInt(this.muteOption);
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(bos);
            out.writeObject((Serializable)((Object)this.whiteList));
            out.close();
            this.byteBuffer = bos.toByteArray();
            buffer.func_179250_a(this.byteBuffer);
            bos = new ByteArrayOutputStream();
            out = new ObjectOutputStream(bos);
            out.writeObject((Serializable)((Object)this.blackList));
            out.close();
            this.byteBuffer = bos.toByteArray();
            buffer.func_179250_a(this.byteBuffer);
        }
        catch (IOException e) {
            ModLogger.error(e);
        }
    }

    @Override
    public void process(EntityPlayer player, Side side) {
        if (this.canProcess) {
            MusicOptionsUtil.setMuteOption(player, this.muteOption);
            MusicOptionsUtil.setBlackList(player, this.blackList);
            MusicOptionsUtil.setWhiteList(player, this.whiteList);
        }
    }
}

