/*
 * Decompiled with CFR 0.152.
 */
package net.aeronica.mods.mxtune.network.server;

import net.aeronica.mods.mxtune.managers.GroupManager;
import net.aeronica.mods.mxtune.network.AbstractMessage;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.relauncher.Side;

public class ManageGroupMessage
extends AbstractMessage.AbstractServerMessage<ManageGroupMessage> {
    private int operation;
    private Integer groupID;
    private Integer memberID;

    public ManageGroupMessage() {
    }

    public ManageGroupMessage(int operation, Integer groupID, Integer memberName) {
        this.operation = operation;
        this.groupID = groupID;
        this.memberID = memberName;
    }

    @Override
    protected void read(PacketBuffer buffer) {
        this.operation = buffer.readInt();
        this.groupID = buffer.readInt();
        this.memberID = buffer.readInt();
    }

    @Override
    protected void write(PacketBuffer buffer) {
        if (this.groupID == null) {
            this.groupID = -1;
        }
        buffer.writeInt(this.operation);
        buffer.writeInt(this.groupID.intValue());
        buffer.writeInt(this.memberID.intValue());
    }

    @Override
    public void process(EntityPlayer player, Side side) {
        switch (this.operation) {
            case 1: {
                GroupManager.addGroup(this.memberID);
                break;
            }
            case 2: {
                GroupManager.addMember(this.groupID, this.memberID);
                break;
            }
            case 3: {
                GroupManager.removeMember(this.memberID);
                break;
            }
            case 4: {
                GroupManager.setLeader(this.memberID);
                break;
            }
        }
    }
}

