/*
 * Decompiled with CFR 0.152.
 */
package net.aeronica.mods.mxtune.network.client;

import io.netty.buffer.ByteBuf;
import net.aeronica.mods.mxtune.managers.GroupHelper;
import net.aeronica.mods.mxtune.network.AbstractMessage;
import net.aeronica.mods.mxtune.sound.ClientAudio;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.relauncher.Side;

public class SyncStatusMessage
extends AbstractMessage.AbstractClientMessage<SyncStatusMessage> {
    private String clientPlayStatuses;
    private String playIDMembers;
    private String activePlayIDs;

    public SyncStatusMessage() {
    }

    public SyncStatusMessage(String clientPlayStatuses, String playIDMembers, String activePlayIDs) {
        this.clientPlayStatuses = clientPlayStatuses;
        this.playIDMembers = playIDMembers;
        this.activePlayIDs = activePlayIDs;
    }

    @Override
    protected void read(PacketBuffer buffer) {
        this.clientPlayStatuses = ByteBufUtils.readUTF8String((ByteBuf)buffer);
        this.playIDMembers = ByteBufUtils.readUTF8String((ByteBuf)buffer);
        this.activePlayIDs = ByteBufUtils.readUTF8String((ByteBuf)buffer);
    }

    @Override
    protected void write(PacketBuffer buffer) {
        ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.clientPlayStatuses);
        ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.playIDMembers);
        ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.activePlayIDs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(EntityPlayer player, Side side) {
        Object object = ClientAudio.THREAD_SYNC;
        synchronized (object) {
            GroupHelper.setClientPlayStatuses(this.clientPlayStatuses);
            GroupHelper.setPlayIDMembers(this.playIDMembers);
            GroupHelper.setActiveServerManagedPlayIDs(this.activePlayIDs);
        }
    }
}

