/*
 * Decompiled with CFR 0.152.
 */
package net.aeronica.mods.mxtune.network.client;

import net.aeronica.mods.mxtune.config.ModConfig;
import net.aeronica.mods.mxtune.managers.GroupHelper;
import net.aeronica.mods.mxtune.network.AbstractMessage;
import net.aeronica.mods.mxtune.network.NetworkStringHelper;
import net.aeronica.mods.mxtune.sound.ClientAudio;
import net.aeronica.mods.mxtune.sound.SoundRange;
import net.aeronica.mods.mxtune.status.ClientCSDMonitor;
import net.aeronica.mods.mxtune.util.MIDISystemUtil;
import net.aeronica.mods.mxtune.util.ModLogger;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PlayBlockMusicMessage
extends AbstractMessage.AbstractClientMessage<PlayBlockMusicMessage> {
    private Integer playID;
    private BlockPos blockPos;
    private String musicText;
    private SoundRange soundRange;
    private NetworkStringHelper stringHelper = new NetworkStringHelper();

    public PlayBlockMusicMessage() {
    }

    public PlayBlockMusicMessage(Integer playID, BlockPos blockPos, String musicText, SoundRange soundRange) {
        this.playID = playID;
        this.blockPos = blockPos;
        this.musicText = musicText;
        this.soundRange = soundRange;
    }

    @Override
    protected void read(PacketBuffer buffer) {
        this.playID = buffer.readInt();
        this.blockPos = buffer.func_179259_c();
        this.musicText = this.stringHelper.readLongString(buffer);
        this.soundRange = (SoundRange)buffer.func_179257_a(SoundRange.class);
    }

    @Override
    protected void write(PacketBuffer buffer) {
        buffer.writeInt(this.playID.intValue());
        buffer.func_179255_a(this.blockPos);
        this.stringHelper.writeLongString(buffer, this.musicText);
        buffer.func_179249_a((Enum)this.soundRange);
    }

    @Override
    public void process(EntityPlayer player, Side side) {
        if (side.isClient()) {
            this.handleClient(player);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void handleClient(EntityPlayer player) {
        if (!MIDISystemUtil.midiUnavailableWarn(player) && ClientCSDMonitor.canMXTunesPlay()) {
            ModLogger.debug("musicText:  " + this.musicText.substring(0, Math.min(25, this.musicText.length())), new Object[0]);
            ModLogger.debug("playID:     " + this.playID, new Object[0]);
            ModLogger.debug("SoundRange: " + (Object)((Object)this.soundRange), new Object[0]);
            GroupHelper.addServerManagedActivePlayID(this.playID);
            ClientAudio.play(this.playID, this.blockPos, this.musicText, this.soundRange);
        } else if (ModConfig.showWelcomeStatusMessage()) {
            ClientCSDMonitor.sendErrorViaChat(player);
        }
    }
}

