/*
 * Decompiled with CFR 0.152.
 */
package net.aeronica.mods.mxtune.network.bidirectional;

import io.netty.buffer.ByteBuf;
import net.aeronica.mods.mxtune.MXTune;
import net.aeronica.mods.mxtune.network.AbstractMessage;
import net.aeronica.mods.mxtune.network.PacketDispatcher;
import net.aeronica.mods.mxtune.options.MusicOptionsUtil;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.relauncher.Side;

public class SendKeyMessage
extends AbstractMessage<SendKeyMessage> {
    private String keyBindingDesc;

    public SendKeyMessage() {
    }

    public SendKeyMessage(String kb) {
        this.keyBindingDesc = kb;
    }

    @Override
    protected void read(PacketBuffer buffer) {
        this.keyBindingDesc = ByteBufUtils.readUTF8String((ByteBuf)buffer);
    }

    @Override
    protected void write(PacketBuffer buffer) {
        ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.keyBindingDesc);
    }

    @Override
    public void process(EntityPlayer player, Side side) {
        if (side.isServer()) {
            this.handleServerSide(player);
        } else {
            this.handleClientSide(player);
        }
    }

    private void handleClientSide(EntityPlayer playerSP) {
        if ("mxtune.key.openParty".equalsIgnoreCase(this.keyBindingDesc)) {
            playerSP.openGui((Object)MXTune.instance, 1, playerSP.func_130014_f_(), 0, 0, 0);
        }
        if ("mxtune.key.openMusicOptions".equalsIgnoreCase(this.keyBindingDesc)) {
            playerSP.openGui((Object)MXTune.instance, 4, playerSP.func_130014_f_(), 0, 0, 0);
        }
    }

    private void handleServerSide(EntityPlayer playerMP) {
        if ("ctrl-down".equalsIgnoreCase(this.keyBindingDesc)) {
            MusicOptionsUtil.setCtrlKey(playerMP, true);
        } else if ("ctrl-up".equalsIgnoreCase(this.keyBindingDesc)) {
            MusicOptionsUtil.setCtrlKey(playerMP, false);
        } else {
            PacketDispatcher.sendTo(new SendKeyMessage(this.keyBindingDesc), (EntityPlayerMP)playerMP);
        }
    }
}

