/*
 * Decompiled with CFR 0.152.
 */
package net.aeronica.mods.mxtune.network;

import net.aeronica.mods.mxtune.util.ModLogger;
import net.minecraft.network.PacketBuffer;

public class NetworkStringHelper {
    private static final int MAX_STRING_BUFFER = 16384;
    private static final String EMPTY_STRING = "";

    public void writeLongString(PacketBuffer buffer, String stringIn) {
        int end;
        int totalLength = stringIn.length();
        int index = 0;
        buffer.writeInt(totalLength);
        buffer.writeInt(stringIn.hashCode());
        do {
            int start = 16384 * index;
            end = Math.min(16384 * (index + 1), totalLength);
            buffer.func_180714_a(stringIn.substring(start, end));
            ++index;
        } while (end < totalLength);
    }

    public String readLongString(PacketBuffer buffer) {
        StringBuilder buildString = new StringBuilder();
        int expectedLength = buffer.readInt();
        int expectedHashCode = buffer.readInt();
        do {
            buildString.append(buffer.func_150789_c(16384));
        } while (buildString.length() < expectedLength);
        String receivedString = buildString.toString();
        if (expectedHashCode == receivedString.hashCode() && expectedLength == receivedString.length()) {
            return receivedString;
        }
        ModLogger.error("StringHelper#readLongString received data error: expected length: %d, actual: %d", expectedLength, receivedString.length());
        ModLogger.error("StringHelper#readLongString received data error: expected hash: %d, actual: %d", expectedHashCode, receivedString.hashCode());
        return EMPTY_STRING;
    }
}

