/*
 * Decompiled with CFR 0.152.
 */
package net.aeronica.mods.mxtune.network;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import net.aeronica.mods.mxtune.util.ModLogger;

public class MultiPacketSerializedObjectManager {
    private static Timer timer;
    private static final Multimap<UUID, TimerTask> tasks;
    private static final Multimap<UUID, SerializedObjectPacket> parts;

    private MultiPacketSerializedObjectManager() {
    }

    public static void start() {
        if (timer == null) {
            timer = new Timer("mxTune MultiPacketSerializedObjectManager Timer");
        }
    }

    public static void shutdown() {
        if (timer != null) {
            timer.purge();
            timer.cancel();
            timer = null;
        }
        parts.clear();
        tasks.clear();
    }

    public static void addPacket(SerializedObjectPacket serializedObjectPart) {
        if (timer != null) {
            parts.put((Object)serializedObjectPart.serialObjectId, (Object)serializedObjectPart);
            MultiPacketSerializedObjectManager.scheduleTimeout(serializedObjectPart.serialObjectId, 30);
            ModLogger.debug("MultiPacketSerializedObjectManager addPacket %s", serializedObjectPart.serialObjectId.toString());
        }
    }

    private static void scheduleTimeout(final UUID uuid, int timeout) {
        if (timer != null) {
            TimerTask task = new TimerTask(){

                @Override
                public void run() {
                    MultiPacketSerializedObjectManager.timedOut(uuid);
                    ModLogger.warn("MultiPacketSerializedObjectManager Timeout for: %s", uuid);
                }
            };
            tasks.put((Object)uuid, (Object)task);
            long delay = (long)timeout * 1000L;
            timer.schedule(task, delay);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void timedOut(UUID uuid) {
        Multimap<UUID, SerializedObjectPacket> multimap = parts;
        synchronized (multimap) {
            if (parts.containsKey((Object)uuid)) {
                parts.removeAll((Object)uuid);
            }
        }
        tasks.removeAll((Object)uuid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int numberOfPackets(UUID uuid) {
        Multimap<UUID, SerializedObjectPacket> multimap = parts;
        synchronized (multimap) {
            return parts.get((Object)uuid).size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static List<SerializedObjectPacket> getPackets(UUID uuid) {
        Multimap<UUID, SerializedObjectPacket> multimap = parts;
        synchronized (multimap) {
            List<SerializedObjectPacket> packets = Collections.unmodifiableList(new ArrayList(parts.get((Object)uuid)));
            MultiPacketSerializedObjectManager.cancel(uuid);
            ModLogger.debug("MultiPacketSerializedObjectManager getPackets: %s", uuid.toString());
            return packets;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cancel(UUID uuid) {
        Object object = parts;
        synchronized (object) {
            parts.removeAll((Object)uuid);
        }
        object = tasks;
        synchronized (object) {
            for (TimerTask timerTask : tasks.get((Object)uuid)) {
                timerTask.cancel();
            }
            tasks.removeAll((Object)uuid);
        }
    }

    static {
        tasks = Multimaps.synchronizedMultimap((Multimap)HashMultimap.create());
        parts = Multimaps.synchronizedMultimap((Multimap)HashMultimap.create());
    }

    public static class SerializedObjectPacket {
        final UUID serialObjectId;
        final int packetId;
        final byte[] bytes;

        public SerializedObjectPacket(UUID serialObjectId, int packetId, byte[] bytes) {
            this.serialObjectId = serialObjectId;
            this.packetId = packetId;
            this.bytes = bytes;
        }
    }
}

