/*
 * Decompiled with CFR 0.152.
 */
package net.aeronica.mods.mxtune.mxt;

import java.util.ArrayList;
import java.util.List;
import net.aeronica.mods.mxtune.managers.records.BaseData;
import net.aeronica.mods.mxtune.mxt.MXTunePart;
import net.aeronica.mods.mxtune.util.GUID;
import net.aeronica.mods.mxtune.util.ModLogger;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class MXTuneFile
extends BaseData {
    private static final String MXT_VERSION = "2.0.0";
    private static final String TAG_TITLE = "title";
    private static final String TAG_AUTHOR = "author";
    private static final String TAG_SOURCE = "source";
    private static final String TAG_DURATION = "duration";
    private static final String TAG_PART_PREFIX = "part";
    private static final String TAG_PART_COUNT = "partCount";
    private static final String TAG_MXT_VERSION = "mxtVersion";
    private static final String ERROR_MSG_MXT_VERSION = "Unsupported mxTune file version! expected %s, found %s, Title: %s";
    private String mxtVersion = "";
    private String title = "";
    private String author = "";
    private String source = "";
    private int duration;
    private List<MXTunePart> parts = new ArrayList<MXTunePart>();

    public static MXTuneFile build(NBTTagCompound compound) {
        MXTuneFile mxTuneFile = new MXTuneFile();
        mxTuneFile.readFromNBT(compound);
        return mxTuneFile;
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        super.readFromNBT(compound);
        this.mxtVersion = compound.func_74779_i(TAG_MXT_VERSION);
        this.title = compound.func_74779_i(TAG_TITLE);
        this.author = compound.func_74779_i(TAG_AUTHOR);
        this.source = compound.func_74779_i(TAG_SOURCE);
        this.duration = compound.func_74762_e(TAG_DURATION);
        int partCount = compound.func_74762_e(TAG_PART_COUNT);
        this.parts = new ArrayList<MXTunePart>();
        for (int i = 0; i < partCount; ++i) {
            NBTTagCompound compoundPart = compound.func_74775_l(TAG_PART_PREFIX + i);
            this.parts.add(new MXTunePart(compoundPart));
        }
        if (MXT_VERSION.compareTo(this.mxtVersion) < 0 || this.mxtVersion.equals("")) {
            ModLogger.warn(ERROR_MSG_MXT_VERSION, MXT_VERSION, this.mxtVersion.equals("") ? "No Version" : this.mxtVersion, this.title);
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound compound) {
        super.writeToNBT(compound);
        compound.func_74778_a(TAG_MXT_VERSION, MXT_VERSION);
        compound.func_74778_a(TAG_TITLE, this.title);
        compound.func_74778_a(TAG_AUTHOR, this.author);
        compound.func_74778_a(TAG_SOURCE, this.source);
        compound.func_74768_a(TAG_DURATION, this.duration);
        compound.func_74768_a(TAG_PART_COUNT, this.parts.size());
        int i = 0;
        for (MXTunePart part : this.parts) {
            NBTTagCompound compoundPart = new NBTTagCompound();
            part.writeToNBT(compoundPart);
            compound.func_74782_a(TAG_PART_PREFIX + i, (NBTBase)compoundPart);
            ++i;
        }
    }

    public String getMxtVersion() {
        return this.mxtVersion;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title.trim();
        this.guid = GUID.stringToSHA2Hash(this.title);
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public int getDuration() {
        return this.duration;
    }

    public void setDuration(int duration) {
        this.duration = duration;
    }

    public List<MXTunePart> getParts() {
        return this.parts;
    }

    public void setParts(List<MXTunePart> parts) {
        this.parts = parts != null ? parts : new ArrayList();
    }

    @Override
    public String getFileName() {
        return this.guid.toString() + ".mxt";
    }

    @Override
    public <T extends BaseData> T factory() {
        return (T)new MXTuneFile();
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }
}

