/*
 * Decompiled with CFR 0.152.
 */
package net.aeronica.mods.mxtune.managers.records;

import java.io.Serializable;
import java.util.Objects;
import net.aeronica.mods.mxtune.Reference;
import net.aeronica.mods.mxtune.util.GUID;
import net.aeronica.mods.mxtune.util.NBTHelper;
import net.minecraft.nbt.NBTTagCompound;

public abstract class BaseData
implements Serializable,
Comparable<GUID> {
    private static final long serialVersionUID = -76044260522231311L;
    protected GUID guid = Reference.EMPTY_GUID;

    public void readFromNBT(NBTTagCompound compound) {
        this.guid = NBTHelper.getGuidFromCompound(compound);
    }

    public void writeToNBT(NBTTagCompound compound) {
        NBTHelper.setGuidToCompound(compound, this.guid);
    }

    public GUID getGUID() {
        return this.guid;
    }

    public String getFileName() {
        return this.guid.toString() + ".dat";
    }

    public abstract <T extends BaseData> T factory();

    public int hashCode() {
        return this.guid.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BaseData baseData = (BaseData)o;
        return Objects.equals(this.guid, baseData.guid);
    }

    @Override
    public int compareTo(GUID o) {
        return this.guid.compareTo(o);
    }
}

