/*
 * Decompiled with CFR 0.152.
 */
package net.aeronica.mods.mxtune.managers;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.aeronica.mods.mxtune.caches.FileHelper;
import net.aeronica.mods.mxtune.gui.mml.ImportHelper;
import net.aeronica.mods.mxtune.managers.records.Song;
import net.aeronica.mods.mxtune.mxt.MXTuneFile;
import net.aeronica.mods.mxtune.mxt.MXTunePart;
import net.aeronica.mods.mxtune.util.ModLogger;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Tuple;
import net.minecraftforge.fml.relauncher.Side;

public final class Update {
    private static final Map<Integer, String> PACKED_PATCH_TO_NAME = new ImmutableMap.Builder().put((Object)0, (Object)"Acoustic Piano").put((Object)4, (Object)"Electric Piano").put((Object)5, (Object)"FM Piano").put((Object)6, (Object)"Harpsichord").put((Object)8, (Object)"Celeste").put((Object)9, (Object)"Glockenspiel").put((Object)10, (Object)"Music Box").put((Object)11, (Object)"Vibraphone").put((Object)13, (Object)"Xylophone").put((Object)19, (Object)"Pipe Organ").put((Object)21, (Object)"Accordion").put((Object)22, (Object)"Harmonica").put((Object)24, (Object)"Nylon Guitar").put((Object)25, (Object)"Steel Guitar").put((Object)26, (Object)"Jazz Guitar").put((Object)29, (Object)"Overdrive Guitar").put((Object)30, (Object)"Distortion Guitar").put((Object)32, (Object)"Acoustic Bass").put((Object)33, (Object)"Fingered Bass").put((Object)34, (Object)"Pick Bass").put((Object)40, (Object)"Violin").put((Object)41, (Object)"Viola").put((Object)42, (Object)"Cello").put((Object)43, (Object)"Double Bass").put((Object)45, (Object)"Pizzicato").put((Object)46, (Object)"Harp").put((Object)47, (Object)"Timpani").put((Object)48, (Object)"Strings").put((Object)49, (Object)"Slow Strings").put((Object)50, (Object)"Synth Strings").put((Object)52, (Object)"Concert Choir").put((Object)55, (Object)"Orchestra Hit").put((Object)56, (Object)"Trumpet").put((Object)57, (Object)"Trombone").put((Object)58, (Object)"Tuba").put((Object)59, (Object)"Muted Trumpet").put((Object)61, (Object)"Brass Section").put((Object)64, (Object)"Soprano Sax").put((Object)65, (Object)"Alto Sax").put((Object)66, (Object)"Tenor Sax").put((Object)67, (Object)"Baritone Sax").put((Object)68, (Object)"Oboe").put((Object)69, (Object)"English Horn").put((Object)70, (Object)"Bassoon").put((Object)71, (Object)"Clarinet").put((Object)72, (Object)"Piccolo").put((Object)73, (Object)"Flute").put((Object)74, (Object)"Recorder").put((Object)75, (Object)"Pan Flute").put((Object)78, (Object)"Irish Tin Whistle").put((Object)79, (Object)"Ocarina").put((Object)104, (Object)"Sitar").put((Object)105, (Object)"Banjo").put((Object)106, (Object)"Shamisen").put((Object)107, (Object)"Koto").put((Object)109, (Object)"Bagpipes").put((Object)110, (Object)"Fiddle").put((Object)111, (Object)"Shenai").put((Object)114, (Object)"Steel Drums").put((Object)116, (Object)"Taiko Drums").put((Object)117, (Object)"Melodic Tom").put((Object)134, (Object)"Coupled Harpsichord").put((Object)208, (Object)"Square Wave").put((Object)209, (Object)"Saw Wave").put((Object)1043, (Object)"Pipe Organ 2").put((Object)1104, (Object)"Sine Wave").put((Object)1536, (Object)"M Lute").put((Object)1537, (Object)"M Ukulele").put((Object)1538, (Object)"M Mandolin").put((Object)1539, (Object)"M Whistle").put((Object)1540, (Object)"M Roncadora").put((Object)1541, (Object)"M Flute").put((Object)1542, (Object)"M Chalumeau").put((Object)1554, (Object)"M Tuba").put((Object)1555, (Object)"M Lyre").put((Object)1556, (Object)"M Electric Guitar").put((Object)1557, (Object)"M Piano").put((Object)1558, (Object)"M Violin").put((Object)1559, (Object)"M Cello").put((Object)1560, (Object)"M Harp").put((Object)1591, (Object)"T Flute").put((Object)1592, (Object)"T Whistle").put((Object)1602, (Object)"M Bass Drum").put((Object)1603, (Object)"M Snare").put((Object)1604, (Object)"M Cymbals").put((Object)1613, (Object)"M Hand Chime").put((Object)16384, (Object)"Standard Set").put((Object)16432, (Object)"Orchestra Set").build();

    private Update() {
    }

    static void renameAreasToPlaylists() {
        Path oldDir = FileHelper.getDirectory("mxtune/areas", Side.SERVER, false);
        Path newDir = FileHelper.getDirectory("mxtune/playlists", Side.SERVER, false);
        ModLogger.info("Try renameAreasToPlaylists()", new Object[0]);
        if (oldDir.toFile().exists() && oldDir.toFile().isDirectory()) {
            try {
                Files.move(oldDir, newDir, StandardCopyOption.ATOMIC_MOVE);
                ModLogger.info("...Renaming <world>/mxtune/areas to <world>/mxtune/playlists", new Object[0]);
            }
            catch (IOException e) {
                ModLogger.info("...Failed to rename <world>/mxtune/areas to <world>/mxtune/playlists", new Object[0]);
                ModLogger.error(e);
            }
        } else {
            ModLogger.info("...Nothing to do", new Object[0]);
        }
    }

    static void convertSongToMxt() {
        List<Object> songFiles = new ArrayList();
        Path path = FileHelper.getDirectory("mxtune/music", Side.SERVER);
        PathMatcher filter = FileHelper.getDatMatcher(path);
        try (Stream<Path> paths = Files.list(path);){
            songFiles = paths.filter(filter::matches).collect(Collectors.toList());
        }
        catch (IOException | NullPointerException e) {
            ModLogger.error(e);
            ModLogger.info("convertSongToMxt: Aborted reading <song>.dat files: %e", e.getLocalizedMessage());
        }
        for (Path songFile : songFiles) {
            boolean error = false;
            MXTuneFile mxTuneFile = new MXTuneFile();
            NBTTagCompound songCompound = FileHelper.getCompoundFromFile(songFile);
            Song song = new Song(songCompound);
            String mxtFileName = FileHelper.removeExtension(song.getFileName()) + ".mxt";
            mxTuneFile.setTitle(song.getTitle());
            for (Tuple<Integer, String> songPart : Update.getSongParts(song)) {
                int packedPatch = (Integer)songPart.func_76341_a();
                MXTunePart mxTunePart = new MXTunePart(PACKED_PATCH_TO_NAME.get(packedPatch), "Converted from Song file", packedPatch, ImportHelper.getStaves((String)songPart.func_76340_b()));
                mxTuneFile.getParts().add(mxTunePart);
            }
            NBTTagCompound compoundMxt = new NBTTagCompound();
            mxTuneFile.writeToNBT(compoundMxt);
            try {
                path = FileHelper.getCacheFile("mxtune/music", mxtFileName, Side.SERVER);
                FileHelper.sendCompoundToFile(path, compoundMxt);
            }
            catch (IOException e) {
                ModLogger.warn(e);
                ModLogger.info("convertSongToMxt: Write Error in %s for %s", "mxtune/music", song.getFileName());
                error = true;
            }
            try {
                if (error || songFile.toFile().isDirectory() || !songFile.toFile().exists()) continue;
                Files.delete(songFile);
            }
            catch (IOException e) {
                ModLogger.error(e);
                ModLogger.info("convertSongToMxt: Delete Error in %s for %s", "mxtune/music", song.getFileName());
            }
        }
    }

    private static List<Tuple<Integer, String>> getSongParts(Song song) {
        ArrayList<Tuple<Integer, String>> songParts = new ArrayList<Tuple<Integer, String>>();
        Pattern patternSplit = Pattern.compile("MML@I=");
        Iterable parts = Splitter.onPattern((String)patternSplit.pattern()).omitEmptyStrings().split((CharSequence)song.getMml());
        for (String part : parts) {
            Tuple<Integer, String> pm = Update.getPatchAndMml(part);
            songParts.add(pm);
        }
        return songParts;
    }

    private static Tuple<Integer, String> getPatchAndMml(String part) {
        Pattern patternPatch = Pattern.compile("(^([0-9]){1,5})");
        int patch = 0;
        Matcher matcher = patternPatch.matcher(part);
        if (matcher.find()) {
            patch = Integer.parseInt(matcher.group(0));
            part = part.replaceFirst(patternPatch.pattern(), "");
        }
        return new Tuple((Object)patch, (Object)part);
    }
}

