/*
 * Decompiled with CFR 0.152.
 */
package net.aeronica.mods.mxtune.managers;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import javax.annotation.Nullable;
import net.aeronica.mods.mxtune.MXTune;
import net.aeronica.mods.mxtune.config.ModConfig;
import net.aeronica.mods.mxtune.sound.ClientAudio;
import net.aeronica.mods.mxtune.util.MapListHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class GroupHelper {
    private static final GroupHelper INSTANCE = new GroupHelper();
    public static final int GROUP_ADD = 1;
    public static final int MEMBER_ADD = 2;
    public static final int MEMBER_REMOVE = 3;
    public static final int MEMBER_PROMOTE = 4;
    static final int QUEUED = 5;
    static final int PLAYING = 6;
    public static final int MAX_MEMBERS = 8;
    private static Map<Integer, Integer> clientGroups = Collections.emptyMap();
    private static Map<Integer, Integer> clientMembers = Collections.emptyMap();
    private static ListMultimap<Integer, Integer> groupsMembers = ArrayListMultimap.create();
    private static Map<Integer, Integer> membersQueuedStatus = Collections.emptyMap();
    private static Map<Integer, Integer> membersPlayID = Collections.emptyMap();
    private static Set<Integer> activeServerManagedPlayIDs = new ConcurrentSkipListSet<Integer>();

    private GroupHelper() {
    }

    public static int getLeaderOfGroup(int leaderID) {
        Integer leader = clientGroups.get(leaderID);
        return leader != null ? leader : -1;
    }

    public static int getMembersGroupLeader(int memberID) {
        return GroupHelper.getLeaderOfGroup(GroupHelper.getMembersGroupID(memberID));
    }

    public static int getMembersGroupID(int memberID) {
        Integer groupID = clientMembers.get(memberID);
        return groupID != null ? clientMembers.get(memberID) : -1;
    }

    private static Set<Integer> getPlayersGroupMembers(EntityPlayer playerIn) {
        int groupID = GroupHelper.getMembersGroupID(playerIn.func_145782_y());
        if (groupID != -1) {
            HashSet members = Sets.newHashSet();
            for (Integer group : groupsMembers.keySet()) {
                if (group == null || groupID != group) continue;
                members.addAll(groupsMembers.get((Object)group));
            }
            return members;
        }
        return Collections.emptySet();
    }

    private static boolean isLeader(Integer memberID) {
        return memberID.equals(GroupHelper.getLeaderOfGroup(GroupHelper.getMembersGroupID(memberID)));
    }

    public static Map<Integer, Integer> getClientMembers() {
        return clientMembers;
    }

    public static void setClientMembers(String members) {
        clientMembers = MapListHelper.deserializeIntIntMap(members);
    }

    public static Map<Integer, Integer> getClientGroups() {
        return clientGroups;
    }

    public static void setClientGroups(String groups) {
        clientGroups = MapListHelper.deserializeIntIntMap(groups);
    }

    public static void setGroupsMembers(String members) {
        groupsMembers = MapListHelper.deserializeIntIntListMultimapSwapped(members);
    }

    @SideOnly(value=Side.CLIENT)
    public static void addServerManagedActivePlayID(int playId) {
        if (playId != -1) {
            activeServerManagedPlayIDs.add(playId);
        }
    }

    public static Set<Integer> getAllPlayIDs() {
        return GroupHelper.mergeSets(activeServerManagedPlayIDs, ClientAudio.getActivePlayIDs());
    }

    private static <T> Set<T> mergeSets(Set<T> a, Set<T> b) {
        HashSet<T> set = new HashSet<T>(a);
        set.addAll(b);
        return Collections.unmodifiableSet(set);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeClientManagedPlayID(int playId) {
        GroupHelper groupHelper = INSTANCE;
        synchronized (groupHelper) {
            ClientAudio.queueAudioDataRemoval(playId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearServerManagedPlayIDs() {
        GroupHelper groupHelper = INSTANCE;
        synchronized (groupHelper) {
            activeServerManagedPlayIDs.clear();
        }
    }

    public static Set<Integer> getServerManagedPlayIDs() {
        return activeServerManagedPlayIDs;
    }

    public static ListMultimap<Integer, Integer> getGroupsMembers() {
        return groupsMembers;
    }

    public static int getIndex(Integer playerID) {
        int result = 0;
        if (membersQueuedStatus != null && membersQueuedStatus.containsKey(playerID)) {
            switch (membersQueuedStatus.get(playerID)) {
                case 5: {
                    result = 1;
                    break;
                }
                case 6: {
                    result = 2;
                    break;
                }
            }
        }
        return result + (GroupHelper.isLeader(playerID) ? 8 : 0);
    }

    public static Map<Integer, Integer> getClientPlayStatuses() {
        return membersQueuedStatus;
    }

    private static Set<Integer> getMembersByPlayID(Integer playID) {
        HashSet members = Sets.newHashSet();
        if (membersPlayID != null) {
            for (Integer someMember : membersPlayID.keySet()) {
                if (!membersPlayID.get(someMember).equals(playID)) continue;
                members.add(someMember);
            }
        }
        return members;
    }

    public static Vec3d getMedianPos(int playID) {
        double z = 0.0;
        double y = 0.0;
        double x = 0.0;
        int count = 0;
        for (int member : GroupHelper.getMembersByPlayID(playID)) {
            EntityPlayer player = MXTune.proxy.getPlayerByEntityID(member);
            if (player == null) continue;
            x += player.func_174791_d().field_72450_a;
            y += player.func_174791_d().field_72448_b;
            z += player.func_174791_d().field_72449_c;
            ++count;
        }
        if (count == 0) {
            return Vec3d.field_186680_a;
        }
        Vec3d pos = new Vec3d(x /= (double)count, y /= (double)count, z /= (double)count);
        return pos;
    }

    public static double getGroupMembersScaledDistance(EntityPlayer playerIn) {
        Set<Integer> members = GroupHelper.getPlayersGroupMembers(playerIn);
        double abortDistance = ModConfig.getGroupPlayAbortDistance();
        double distance = 0.0;
        double maxDistance = 0.0;
        for (Integer memberA : members) {
            for (Integer memberB : members) {
                if (memberA.intValue() == memberB.intValue()) continue;
                double playerDistance = GroupHelper.getMemberVector(memberA).func_72438_d(GroupHelper.getMemberVector(memberB));
                if (playerDistance > maxDistance) {
                    maxDistance = playerDistance;
                }
                distance = Math.min(1.0, maxDistance / abortDistance);
            }
        }
        return distance;
    }

    private static Vec3d getMemberVector(Integer entityID) {
        EntityPlayer player = (EntityPlayer)MXTune.proxy.getClientPlayer().func_130014_f_().func_73045_a(entityID.intValue());
        Vec3d v3d = player != null ? new Vec3d(player.field_70165_t, player.field_70167_r, player.field_70161_v) : new Vec3d(0.0, 0.0, 0.0);
        return v3d;
    }

    public static boolean isClientPlaying(Integer playID) {
        Set<Integer> members = GroupHelper.getMembersByPlayID(playID);
        return !members.isEmpty() && members.contains(MXTune.proxy.getClientPlayer().func_145782_y());
    }

    public static boolean playerHasPlayID(Integer entityID, int playID) {
        Set<Integer> members = GroupHelper.getMembersByPlayID(playID);
        return !members.isEmpty() && members.contains(entityID);
    }

    public static boolean isPlayIDPlaying(Integer playID) {
        return activeServerManagedPlayIDs != null && activeServerManagedPlayIDs.contains(playID);
    }

    public static void setClientPlayStatuses(String clientPlayStatuses) {
        membersQueuedStatus = MapListHelper.deserializeIntIntMap(clientPlayStatuses);
    }

    public static Map<Integer, Integer> getPlayIDMembers() {
        return membersPlayID;
    }

    @Nullable
    public static Integer getSoloMemberByPlayID(int playID) {
        for (Integer someMember : membersPlayID.keySet()) {
            if (!membersPlayID.get(someMember).equals(playID)) continue;
            return someMember;
        }
        return null;
    }

    public static void setPlayIDMembers(String playIDMembers) {
        membersPlayID = MapListHelper.deserializeIntIntMap(playIDMembers);
    }

    public static void setActiveServerManagedPlayIDs(String setIntString) {
        Set<Integer> receivedSet = MapListHelper.deserializeIntegerSet(setIntString);
        activeServerManagedPlayIDs.addAll(receivedSet);
        activeServerManagedPlayIDs.removeIf(playID -> !receivedSet.contains(playID));
    }
}

