/*
 * Decompiled with CFR 0.152.
 */
package net.aeronica.mods.mxtune.managers;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.aeronica.mods.mxtune.managers.Member;

public class Group {
    public static final Group EMPTY = new Group();
    private int groupID;
    private int playID;
    private int maxDuration;
    private int leaderEntityID;
    private Set<Member> members;

    private Group() {
        this.members = Collections.unmodifiableSet(Collections.emptySet());
    }

    public Group(int groupID, int leaderEntityID) {
        this.groupID = groupID;
        this.leaderEntityID = leaderEntityID;
        this.members = new HashSet<Member>(8);
        this.maxDuration = 0;
        this.playID = -1;
    }

    public int getGroupID() {
        return this.groupID;
    }

    void setLeaderEntityID(Integer leaderEntityID) {
        this.leaderEntityID = leaderEntityID;
    }

    int getLeaderEntityID() {
        return this.leaderEntityID;
    }

    Set<Member> getMembers() {
        return this.members;
    }

    void addMember(Member member) {
        this.members.add(member);
    }

    public int getPlayID() {
        return this.playID;
    }

    public void setPlayID(int playID) {
        this.playID = playID;
    }

    void setPartDuration(int duration) {
        if (duration > this.maxDuration) {
            this.maxDuration = duration;
        }
    }

    int getMaxDuration() {
        return this.maxDuration;
    }

    boolean isEmpty() {
        return this == EMPTY;
    }
}

