/*
 * Decompiled with CFR 0.152.
 */
package net.aeronica.mods.mxtune.handler;

import net.aeronica.mods.mxtune.blocks.TileBandAmp;
import net.aeronica.mods.mxtune.config.ModConfig;
import net.aeronica.mods.mxtune.gui.GuiBandAmp;
import net.aeronica.mods.mxtune.gui.GuiGroup;
import net.aeronica.mods.mxtune.gui.GuiGroupJoin;
import net.aeronica.mods.mxtune.gui.GuiMultiInstInventory;
import net.aeronica.mods.mxtune.gui.GuiMusicOptions;
import net.aeronica.mods.mxtune.gui.mml.GuiChunkTool;
import net.aeronica.mods.mxtune.gui.mml.GuiGuiMultiInstChooser;
import net.aeronica.mods.mxtune.gui.mml.GuiMXT;
import net.aeronica.mods.mxtune.gui.mml.GuiMusicLibrary;
import net.aeronica.mods.mxtune.gui.mml.GuiPlaylistManager;
import net.aeronica.mods.mxtune.inventory.ContainerBandAmp;
import net.aeronica.mods.mxtune.inventory.ContainerInstrument;
import net.aeronica.mods.mxtune.world.LockableHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.IGuiHandler;

public class GUIHandler
implements IGuiHandler {
    private GUIHandler() {
    }

    public static GUIHandler getInstance() {
        return GUIHandlerHolder.INSTANCE;
    }

    public Object getServerGuiElement(int guiID, EntityPlayer playerIn, World worldIn, int x, int y, int z) {
        switch (guiID) {
            case 10: {
                return new ContainerInstrument(playerIn);
            }
            case 5: {
                if (!LockableHelper.isLocked(playerIn, worldIn, x, y, z)) {
                    return new ContainerBandAmp(playerIn.field_71071_by, worldIn, x, y, z);
                }
                return null;
            }
        }
        return null;
    }

    public Object getClientGuiElement(int guiID, EntityPlayer playerIn, World worldIn, int x, int y, int z) {
        switch (guiID) {
            case 3: {
                return new GuiMXT(null, GuiMXT.Mode.SHEET_MUSIC);
            }
            case 10: {
                return new GuiMultiInstInventory(new ContainerInstrument(playerIn));
            }
            case 11: {
                return new GuiGuiMultiInstChooser(null);
            }
            case 1: {
                return ModConfig.isJAMPartyRightClickDisabled() ? null : new GuiGroup();
            }
            case 2: {
                return ModConfig.isJAMPartyRightClickDisabled() ? null : new GuiGroupJoin();
            }
            case 4: {
                return new GuiMusicOptions(null);
            }
            case 5: {
                return new GuiBandAmp((Container)this.getServerGuiElement(guiID, playerIn, worldIn, x, y, z), playerIn.field_71071_by, (TileBandAmp)worldIn.func_175625_s(new BlockPos(x, y, z)));
            }
            case 6: {
                return new GuiMusicLibrary(null);
            }
            case 7: {
                return new GuiPlaylistManager();
            }
            case 8: {
                return new GuiMXT(null, GuiMXT.Mode.CLIENT);
            }
            case 9: {
                return new GuiChunkTool();
            }
        }
        return null;
    }

    private static class GUIHandlerHolder {
        private static final GUIHandler INSTANCE = new GUIHandler();

        private GUIHandlerHolder() {
        }
    }
}

