/*
 * Decompiled with CFR 0.152.
 */
package net.aeronica.mods.mxtune.gui.util;

import com.google.common.collect.ComparisonChain;
import java.util.Comparator;
import java.util.Locale;
import net.aeronica.mods.mxtune.gui.util.GuiButtonMX;
import net.minecraft.client.Minecraft;
import net.minecraft.util.StringUtils;

public abstract class GuiSortButton<T>
extends GuiButtonMX
implements Comparator<T> {
    private static final String ASCENDING = "\u25b2";
    private static final String DESCENDING = "\u25bc";
    private static final String NATURAL = "\u25ac";
    private String displayAscending = "";
    private String displayDescending = "";
    private String displayNatural = "";
    private int sortMode = 0;
    private boolean naturalOrderOption = false;

    public GuiSortButton(int buttonId, int x, int y) {
        super(buttonId, x, y, 20, 20, "");
        this.setButtonText();
    }

    public GuiSortButton(int buttonId, int x, int y, int widthIn, int heightIn) {
        super(buttonId, x, y, widthIn, heightIn, "");
        this.setButtonText();
    }

    @Override
    public int compare(T o1, T o2) {
        switch (this.getSortMode()) {
            case 0: {
                return ComparisonChain.start().compare((Comparable)((Object)this.stripCase(o1)), (Comparable)((Object)this.stripCase(o2))).result();
            }
            case 1: {
                return ComparisonChain.start().compare((Comparable)((Object)this.stripCase(o2)), (Comparable)((Object)this.stripCase(o1))).result();
            }
            case 2: {
                return 0;
            }
        }
        return 0;
    }

    public boolean func_146116_c(Minecraft mc, int mouseX, int mouseY) {
        if (this.func_146115_a()) {
            ++this.sortMode;
            this.setButtonText();
        }
        return super.func_146116_c(mc, mouseX, mouseY);
    }

    public abstract String getString(T var1);

    private String stripCase(T o) {
        return StringUtils.func_76338_a((String)this.getString(o)).toLowerCase(Locale.ROOT);
    }

    public int getSortMode() {
        return this.sortMode % (this.naturalOrderOption ? 3 : 2);
    }

    public void setSortMode(int sortMode) {
        this.sortMode = sortMode;
        this.setButtonText();
    }

    public void setDisplayText(String displayAscending, String displayDescending, String displayNatural) {
        this.displayAscending = displayAscending;
        this.displayDescending = displayDescending;
        this.displayNatural = displayNatural;
        this.setButtonText();
    }

    public boolean hasNaturalOrderOption() {
        return this.naturalOrderOption;
    }

    public void setNaturalOrderOption(boolean naturalOrderOption) {
        this.naturalOrderOption = naturalOrderOption;
    }

    private void setButtonText() {
        switch (this.getSortMode()) {
            case 0: {
                this.field_146126_j = this.displayAscending.isEmpty() ? ASCENDING : this.displayAscending;
                break;
            }
            case 1: {
                this.field_146126_j = this.displayDescending.isEmpty() ? DESCENDING : this.displayDescending;
                break;
            }
            case 2: {
                this.field_146126_j = this.displayNatural.isEmpty() ? NATURAL : this.displayNatural;
                break;
            }
        }
    }
}

