/*
 * Decompiled with CFR 0.152.
 */
package net.aeronica.mods.mxtune.gui.util;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiLabelMX
extends Gui {
    private int width;
    private int height;
    private int x;
    private int y;
    private String labelName;
    private String labelText;
    private TextFormatting textFormatting = TextFormatting.RESET;
    public final int id;
    private boolean centered;
    private boolean visible = true;
    private boolean labelBgEnabled;
    private final int textColor;
    private int backColor;
    private int ulColor;
    private int brColor;
    private final FontRenderer fontRenderer;
    private int border;

    public GuiLabelMX(FontRenderer fontRendererObj, int labelId, int xIn, int yIn, int widthIn, int heightIn, int colorIn) {
        this.fontRenderer = fontRendererObj;
        this.id = labelId;
        this.x = xIn;
        this.y = yIn;
        this.width = widthIn;
        this.height = heightIn;
        this.labelName = "";
        this.labelText = "";
        this.centered = false;
        this.labelBgEnabled = false;
        this.textColor = colorIn;
        this.backColor = -1;
        this.ulColor = -1;
        this.brColor = -1;
        this.border = 0;
    }

    public void setLabelName(String labelName) {
        this.labelName = labelName;
    }

    public String getLabelName() {
        return this.labelName;
    }

    public String getLabelText() {
        return this.labelText;
    }

    public void setLabelText(String labelText) {
        this.labelText = labelText;
    }

    public GuiLabelMX setCentered() {
        this.centered = true;
        return this;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        this.x = x;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int y) {
        this.y = y;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public TextFormatting getTextFormatting() {
        return this.textFormatting;
    }

    public void setTextFormatting(TextFormatting textFormatting) {
        this.textFormatting = textFormatting;
    }

    public void drawLabel(Minecraft mc, int mouseX, int mouseY) {
        if (this.visible) {
            GlStateManager.func_179147_l();
            GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            String combinedTexts = this.labelName + " " + this.textFormatting + this.labelText;
            this.drawLabelBackground(mc, mouseX, mouseY);
            if (this.centered) {
                this.func_73732_a(this.fontRenderer, combinedTexts, this.x + this.width / 2, this.y, this.textColor);
            } else {
                this.func_73731_b(this.fontRenderer, combinedTexts, this.x, this.y, this.textColor);
            }
        }
    }

    protected void drawLabelBackground(Minecraft mcIn, int mouseX, int mouseY) {
        if (this.labelBgEnabled) {
            int i = this.width + this.border * 2;
            int j = this.height + this.border * 2;
            int k = this.x - this.border;
            int l = this.y - this.border;
            GuiLabelMX.func_73734_a((int)k, (int)l, (int)(k + i), (int)(l + j), (int)this.backColor);
            this.func_73730_a(k, k + i, l, this.ulColor);
            this.func_73730_a(k, k + i, l + j, this.brColor);
            this.func_73728_b(k, l, l + j, this.ulColor);
            this.func_73728_b(k + i, l, l + j, this.brColor);
        }
    }
}

