/*
 * Decompiled with CFR 0.152.
 */
package net.aeronica.mods.mxtune.gui.mml;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.aeronica.mods.mxtune.caches.DirectoryWatcher;
import net.aeronica.mods.mxtune.caches.FileHelper;
import net.aeronica.mods.mxtune.gui.mml.ActionGet;
import net.aeronica.mods.mxtune.gui.mml.FileData;
import net.aeronica.mods.mxtune.gui.mml.SortFileDataHelper;
import net.aeronica.mods.mxtune.gui.util.GuiScrollingListOf;
import net.aeronica.mods.mxtune.gui.util.ModGuiUtils;
import net.aeronica.mods.mxtune.managers.PlayIdSupplier;
import net.aeronica.mods.mxtune.mxt.MXTuneFile;
import net.aeronica.mods.mxtune.mxt.MXTuneFileHelper;
import net.aeronica.mods.mxtune.mxt.MXTunePart;
import net.aeronica.mods.mxtune.sound.ClientAudio;
import net.aeronica.mods.mxtune.sound.IAudioStatusCallback;
import net.aeronica.mods.mxtune.util.MIDISystemUtil;
import net.aeronica.mods.mxtune.util.ModLogger;
import net.aeronica.mods.mxtune.util.SoundFontProxyManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiLabel;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.resources.I18n;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.client.config.GuiButtonExt;
import net.minecraftforge.fml.relauncher.Side;
import org.lwjgl.input.Mouse;

public class GuiMusicLibrary
extends GuiScreen
implements IAudioStatusCallback {
    private static final String TITLE = I18n.func_135052_a((String)"mxtune.gui.guiMusicLibrary.title", (Object[])new Object[0]);
    private static final String MIDI_NOT_AVAILABLE = I18n.func_135052_a((String)"mxtune.chat.msu.midiNotAvailable", (Object[])new Object[0]);
    private GuiScreen guiScreenParent;
    private int guiLeft;
    private int guiTop;
    private boolean isStateCached;
    private boolean midiUnavailable;
    private GuiButton buttonCancel;
    private List<GuiButton> safeButtonList;
    private GuiScrollingListOf<FileData> guiLibraryList;
    private List<Path> libraryFiles = new ArrayList<Path>();
    private GuiLabel searchLabel;
    private GuiTextField search;
    private boolean sorted = false;
    private SortFileDataHelper.SortType sortType = SortFileDataHelper.SortType.NATURAL;
    private String lastSearch = "";
    private int cachedSelectedIndex = -1;
    private SortFileDataHelper.SortType cachedSortType;
    private boolean cachedIsPlaying;
    private int cachedPlayId;
    private MXTuneFile mxTuneFile;
    private GuiScrollingListOf<MXTunePart> guiPartList;
    private List<MXTunePart> tuneParts = new ArrayList<MXTunePart>();
    private GuiButton buttonPlay;
    private boolean isPlaying = false;
    private int playId = -1;
    private boolean watcherStarted = false;
    private DirectoryWatcher watcher;

    public GuiMusicLibrary(GuiScreen guiScreenParent) {
        this.guiScreenParent = guiScreenParent;
        this.field_146297_k = Minecraft.func_71410_x();
        this.field_146289_q = this.field_146297_k.field_71466_p;
        this.midiUnavailable = MIDISystemUtil.midiUnavailable();
        this.guiLibraryList = new GuiScrollingListOf<FileData>((GuiScreen)this){

            @Override
            protected void drawSlot(int slotIdx, int entryRight, int slotTop, int slotBuffer, Tessellator tess) {
                if (!this.isEmpty() && slotIdx >= 0 && slotIdx < this.size()) {
                    String name = this.get(slotIdx) != null ? ((FileData)this.get((int)slotIdx)).name : "";
                    String trimmedName = GuiMusicLibrary.this.field_146289_q.func_78269_a(name, this.listWidth - 10);
                    int color = this.isSelected(slotIdx) ? 0xFFFF00 : 11393254;
                    GuiMusicLibrary.this.field_146289_q.func_175063_a(trimmedName, (float)this.left + 3.0f, (float)slotTop, color);
                }
            }

            @Override
            protected void selectedClickedCallback(int selectedIndex) {
                GuiMusicLibrary.this.updatePartList();
            }

            @Override
            protected void selectedDoubleClickedCallback(int selectedIndex) {
                GuiMusicLibrary.this.selectDone();
            }
        };
        this.guiPartList = new GuiScrollingListOf<MXTunePart>((GuiScreen)this){

            @Override
            protected void selectedClickedCallback(int selectedIndex) {
            }

            @Override
            protected void selectedDoubleClickedCallback(int selectedIndex) {
            }

            @Override
            protected void drawSlot(int slotIdx, int entryRight, int slotTop, int slotBuffer, Tessellator tess) {
                if (!this.isEmpty() && slotIdx >= 0 && slotIdx < this.size() && this.get(slotIdx) != null) {
                    MXTunePart tunePart = (MXTunePart)this.get(slotIdx);
                    String translatedName = I18n.func_135052_a((String)SoundFontProxyManager.getLangKeyName(tunePart.getInstrumentName()), (Object[])new Object[0]);
                    String trimmedName = GuiMusicLibrary.this.field_146289_q.func_78269_a(translatedName, this.listWidth - 10);
                    GuiMusicLibrary.this.field_146289_q.func_175063_a(trimmedName, (float)this.left + 3.0f, (float)slotTop, 11393254);
                }
            }
        };
        DirectoryStream.Filter<Path> filter = entry -> entry.toString().endsWith(".mxt");
        this.watcher = new DirectoryWatcher.Builder().addDirectories(FileHelper.getDirectory("mxtune/library", Side.CLIENT)).setPreExistingAsCreated(true).setFilter(filter::accept).build((event, path) -> {
            switch (event) {
                case ENTRY_CREATE: 
                case ENTRY_MODIFY: 
                case ENTRY_DELETE: {
                    this.func_73866_w_();
                }
            }
        });
    }

    public void func_146281_b() {
        this.stopWatcher();
    }

    private void startWatcher() {
        if (!this.watcherStarted) {
            try {
                this.watcherStarted = true;
                this.watcher.start();
            }
            catch (Exception e) {
                this.watcherStarted = false;
                ModLogger.error(e);
            }
        }
    }

    private void stopWatcher() {
        if (this.watcherStarted) {
            this.watcher.stop();
        }
    }

    public void func_73866_w_() {
        this.field_146292_n.clear();
        this.guiLeft = 0;
        this.guiTop = 0;
        int guiListWidth = (this.field_146294_l - 15) * 3 / 4;
        int entryHeight = this.field_146297_k.field_71466_p.field_78288_b + 2;
        int left = 5;
        int titleTop = 20;
        int listTop = titleTop + 25;
        int listHeight = this.field_146295_m - titleTop - entryHeight - 2 - 10 - 25 - 25;
        int listBottom = listTop + listHeight;
        int statusTop = listBottom + 4;
        int partListWidth = (this.field_146294_l - 15) / 4;
        this.guiLibraryList.setLayout(entryHeight, guiListWidth, listHeight, listTop, listBottom, left);
        this.guiPartList.setLayout(entryHeight, partListWidth, listHeight, listTop, listBottom, this.guiLibraryList.getRight() + 5);
        String searchLabelText = I18n.func_135052_a((String)"mxtune.gui.label.search", (Object[])new Object[0]);
        int searchLabelWidth = this.field_146289_q.func_78256_a(searchLabelText) + 4;
        this.searchLabel = new GuiLabel(this.field_146289_q, 0, left, statusTop, searchLabelWidth, entryHeight + 2, 0xFFFFFF);
        this.searchLabel.func_175202_a(searchLabelText);
        this.searchLabel.field_146172_j = true;
        this.search = new GuiTextField(0, this.field_146289_q, left + searchLabelWidth, statusTop, guiListWidth - searchLabelWidth, entryHeight + 2);
        this.search.func_146195_b(true);
        this.search.func_146205_d(true);
        int buttonMargin = 1;
        int buttonWidth = 75;
        int x = left;
        GuiButtonExt normalSort = new GuiButtonExt(SortFileDataHelper.SortType.NATURAL.getButtonID(), x, titleTop, buttonWidth - buttonMargin, 20, I18n.func_135052_a((String)"fml.menu.mods.normal", (Object[])new Object[0]));
        normalSort.field_146124_l = false;
        this.field_146292_n.add(normalSort);
        this.field_146292_n.add(new GuiButtonExt(SortFileDataHelper.SortType.ASCENDING.getButtonID(), x += buttonWidth + buttonMargin, titleTop, buttonWidth - buttonMargin, 20, "A-Z"));
        this.field_146292_n.add(new GuiButtonExt(SortFileDataHelper.SortType.DESCENDING.getButtonID(), x += buttonWidth + buttonMargin, titleTop, buttonWidth - buttonMargin, 20, "Z-A"));
        int buttonTop = this.field_146295_m - 25;
        int xOpen = this.field_146294_l / 2 - 187;
        int xRefresh = xOpen + 75;
        int xPlay = xRefresh + 75;
        int xSelect = xPlay + 75;
        int xCancel = xSelect + 75;
        GuiButton buttonOpen = new GuiButton(2, xOpen, buttonTop, 75, 20, I18n.func_135052_a((String)"mxtune.gui.button.openFolder", (Object[])new Object[0]));
        GuiButton buttonRefresh = new GuiButton(3, xRefresh, buttonTop, 75, 20, I18n.func_135052_a((String)"mxtune.gui.button.refresh", (Object[])new Object[0]));
        this.buttonPlay = new GuiButton(3, xPlay, buttonTop, 75, 20, this.isPlaying ? I18n.func_135052_a((String)"mxtune.gui.button.stop", (Object[])new Object[0]) : I18n.func_135052_a((String)"mxtune.gui.button.play", (Object[])new Object[0]));
        GuiButton buttonDone = new GuiButton(0, xSelect, buttonTop, 75, 20, I18n.func_135052_a((String)"mxtune.gui.button.select", (Object[])new Object[0]));
        this.buttonCancel = new GuiButton(1, xCancel, buttonTop, 75, 20, I18n.func_135052_a((String)"gui.cancel", (Object[])new Object[0]));
        this.field_146292_n.add(buttonOpen);
        this.field_146292_n.add(buttonRefresh);
        this.field_146292_n.add(this.buttonPlay);
        this.field_146292_n.add(buttonDone);
        this.field_146292_n.add(this.buttonCancel);
        this.safeButtonList = new CopyOnWriteArrayList<GuiButton>(this.field_146292_n);
        this.sorted = false;
        this.startWatcher();
        this.initFileList();
        this.reloadState();
        SortFileDataHelper.updateSortButtons(this.sortType, this.safeButtonList);
    }

    private void reloadState() {
        if (!this.isStateCached) {
            return;
        }
        this.sortType = this.cachedSortType;
        this.search.func_146180_a(this.lastSearch);
        this.guiLibraryList.setSelectedIndex(this.cachedSelectedIndex);
        this.updatePartList();
        this.guiLibraryList.resetScroll();
        this.isPlaying = this.cachedIsPlaying;
        this.playId = this.cachedPlayId;
    }

    private void updateState() {
        this.cachedSortType = this.sortType;
        this.cachedSelectedIndex = this.guiLibraryList.getSelectedIndex();
        this.cachedIsPlaying = this.isPlaying;
        this.cachedPlayId = this.playId;
        this.searchAndSort();
        this.buttonPlay.field_146126_j = this.isPlaying ? I18n.func_135052_a((String)"mxtune.gui.button.stop", (Object[])new Object[0]) : I18n.func_135052_a((String)"mxtune.gui.button.play", (Object[])new Object[0]);
        this.isStateCached = true;
    }

    public void func_73876_c() {
        this.search.func_146178_a();
        super.func_73876_c();
    }

    public boolean func_73868_f() {
        return false;
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        String guiMusicLibTitle = this.midiUnavailable ? TITLE + " - " + TextFormatting.RED + MIDI_NOT_AVAILABLE : TITLE;
        int posX = (this.field_146294_l - this.field_146297_k.field_71466_p.func_78256_a(guiMusicLibTitle)) / 2;
        int posY = 5;
        this.field_146297_k.field_71466_p.func_175063_a(guiMusicLibTitle, (float)posX, (float)posY, 0xD3D3D3);
        this.guiLibraryList.drawScreen(mouseX, mouseY, partialTicks);
        this.guiPartList.drawScreen(mouseX, mouseY, partialTicks);
        this.searchLabel.func_146159_a(this.field_146297_k, mouseX, mouseY);
        this.search.func_146194_f();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        ModGuiUtils.INSTANCE.drawHooveringHelp(this, this.safeButtonList, this.guiLeft, this.guiTop, mouseX, mouseY);
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        if (button.field_146124_l) {
            SortFileDataHelper.SortType type = SortFileDataHelper.SortType.getSortTypeForButton(button);
            if (type != null) {
                SortFileDataHelper.updateSortButtons(type, this.field_146292_n);
                this.sorted = false;
                this.sortType = type;
                this.initFileList();
            } else {
                switch (button.field_146127_k) {
                    case 0: {
                        this.selectDone();
                        break;
                    }
                    case 2: {
                        this.openFolder();
                        break;
                    }
                    case 1: {
                        this.selectCancel();
                        break;
                    }
                    case 3: {
                        this.play();
                        break;
                    }
                    case 4: {
                        this.refresh();
                        break;
                    }
                }
            }
        }
        this.updateState();
        super.func_146284_a(button);
    }

    private void selectDone() {
        if (this.guiLibraryList.isSelected(this.guiLibraryList.getSelectedIndex())) {
            ActionGet.INSTANCE.select(this.guiLibraryList.get((int)this.guiLibraryList.getSelectedIndex()).path);
        }
        this.stop();
        this.field_146297_k.func_147108_a(this.guiScreenParent);
    }

    private void selectCancel() {
        this.stop();
        this.field_146297_k.func_147108_a(this.guiScreenParent);
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        this.search.func_146201_a(typedChar, keyCode);
        if (keyCode == 1) {
            this.func_146284_a(this.buttonCancel);
            return;
        }
        this.guiLibraryList.keyTyped(typedChar, keyCode);
        this.updateState();
        super.func_73869_a(typedChar, keyCode);
    }

    public void func_175273_b(@Nonnull Minecraft mcIn, int w, int h) {
        this.updateState();
        super.func_175273_b(mcIn, w, h);
    }

    public void func_146274_d() throws IOException {
        int mouseX = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
        int mouseY = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
        this.guiLibraryList.handleMouseInput(mouseX, mouseY);
        this.guiPartList.handleMouseInput(mouseX, mouseY);
        super.func_146274_d();
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        this.search.func_146192_a(mouseX, mouseY, mouseButton);
        ModGuiUtils.clearOnMouseLeftClicked(this.search, mouseX, mouseY, mouseButton);
        super.func_73864_a(mouseX, mouseY, mouseButton);
        this.updateState();
    }

    private void initFileList() {
        Path path = FileHelper.getDirectory("mxtune/library", Side.CLIENT);
        PathMatcher filter = FileHelper.getMxtMatcher(path);
        try (Stream<Path> paths = Files.list(path);){
            this.libraryFiles = paths.filter(filter::matches).collect(Collectors.toList());
        }
        catch (IOException | NullPointerException e) {
            ModLogger.error(e);
        }
        ArrayList<Path> files = new ArrayList<Path>();
        ArrayList<FileData> fileDatas = new ArrayList<FileData>();
        for (Path file : this.libraryFiles) {
            FileData fileData = new FileData(file);
            if (!fileData.name.toLowerCase(Locale.ROOT).contains(this.search.func_146179_b().toLowerCase(Locale.ROOT))) continue;
            fileDatas.add(fileData);
        }
        this.libraryFiles = files;
        this.guiLibraryList.clear();
        this.guiLibraryList.addAll(fileDatas);
        this.lastSearch = this.search.func_146179_b();
    }

    private void searchAndSort() {
        if (!this.search.func_146179_b().equals(this.lastSearch)) {
            this.initFileList();
            this.sorted = false;
            this.updatePartList();
        }
        if (!this.sorted) {
            this.initFileList();
            this.guiLibraryList.sort(this.sortType);
            this.sorted = true;
            this.updatePartList();
        }
    }

    private void updatePartList() {
        if (this.guiLibraryList.isSelected(this.guiLibraryList.getSelectedIndex())) {
            Path path = this.guiLibraryList.get((int)this.guiLibraryList.getSelectedIndex()).path;
            NBTTagCompound compound = FileHelper.getCompoundFromFile(path);
            this.tuneParts.clear();
            if (compound != null) {
                this.mxTuneFile = MXTuneFile.build(compound);
                this.tuneParts.addAll(this.mxTuneFile.getParts());
            }
            this.guiPartList.clear();
            this.guiPartList.addAll(this.tuneParts);
            ModLogger.debug("Selected file: %s", path.toString());
        } else if (this.guiLibraryList.isEmpty()) {
            this.guiPartList.clear();
        }
    }

    private void play() {
        if (this.isPlaying) {
            this.stop();
        } else if (this.mxTuneFile != null) {
            this.isPlaying = true;
            String mml = MXTuneFileHelper.getMML(this.mxTuneFile);
            this.playId = PlayIdSupplier.PlayType.PERSONAL.getAsInt();
            ClientAudio.playLocal(this.playId, mml, this);
        }
    }

    private void stop() {
        ClientAudio.fadeOut(this.playId, 1);
        this.isPlaying = false;
        this.playId = -1;
    }

    @Override
    public void statusCallBack(ClientAudio.Status status, int playId) {
        Minecraft.func_71410_x().func_152344_a(() -> {
            if (this.playId == playId && (status == ClientAudio.Status.ERROR || status == ClientAudio.Status.DONE)) {
                ModLogger.debug("AudioStatus event received: %s, playId: %s", new Object[]{status, playId});
                this.stop();
                this.updateState();
            }
        });
    }

    private void openFolder() {
        FileHelper.openFolder("mxtune/library");
    }

    private void refresh() {
        this.func_73866_w_();
    }
}

