/*
 * Decompiled with CFR 0.152.
 */
package net.aeronica.mods.mxtune.gui.mml;

import java.io.IOException;
import javax.annotation.Nonnull;
import net.aeronica.mods.mxtune.gui.mml.SortHelper;
import net.aeronica.mods.mxtune.gui.util.GuiButtonMX;
import net.aeronica.mods.mxtune.gui.util.GuiScrollingListOf;
import net.aeronica.mods.mxtune.gui.util.ModGuiUtils;
import net.aeronica.mods.mxtune.managers.ClientFileManager;
import net.aeronica.mods.mxtune.managers.records.PlayList;
import net.aeronica.mods.mxtune.managers.records.RecordType;
import net.aeronica.mods.mxtune.network.PacketDispatcher;
import net.aeronica.mods.mxtune.network.bidirectional.GetBaseDataListsMessage;
import net.aeronica.mods.mxtune.network.server.ChunkToolMessage;
import net.aeronica.mods.mxtune.network.server.PlayerSelectedPlayListMessage;
import net.aeronica.mods.mxtune.options.MusicOptionsUtil;
import net.aeronica.mods.mxtune.util.CallBack;
import net.aeronica.mods.mxtune.util.CallBackManager;
import net.aeronica.mods.mxtune.util.Notify;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class GuiChunkTool
extends GuiScreen
implements Notify {
    private static final ResourceLocation guiTexture = new ResourceLocation("mxtune", "textures/gui/manage_group.png");
    private int xSize = 239;
    private int ySize = 164;
    private int guiLeft;
    private int guiTop;
    private boolean isStateCached;
    private GuiScrollingListOf<PlayList> guiPlayLists;
    private GuiButtonMX buttonStart;
    private GuiButtonMX buttonEnd;
    private GuiButtonMX buttonApply;
    private GuiButtonMX buttonReset;
    private EntityPlayer player;

    public GuiChunkTool() {
        this.field_146297_k = Minecraft.func_71410_x();
        this.player = this.field_146297_k.field_71439_g;
        this.field_146289_q = this.field_146297_k.field_71466_p;
        this.guiPlayLists = new GuiScrollingListOf<PlayList>((GuiScreen)this){

            @Override
            protected void selectedClickedCallback(int selectedIndex) {
                PlayList playList = (PlayList)this.get();
                if (playList != null) {
                    PacketDispatcher.sendToServer(new PlayerSelectedPlayListMessage(playList.getGUID()));
                    GuiChunkTool.this.initPlayLists();
                }
            }

            @Override
            protected void selectedDoubleClickedCallback(int selectedIndex) {
            }

            @Override
            protected void drawSlot(int slotIdx, int entryRight, int slotTop, int slotBuffer, Tessellator tess) {
                PlayList playList;
                PlayList playList2 = playList = !this.isEmpty() && slotIdx < this.getSize() && slotIdx >= 0 ? (PlayList)this.get(slotIdx) : null;
                if (playList != null) {
                    String playlistName = ModGuiUtils.getPlaylistName(playList);
                    String trimmedName = GuiChunkTool.this.field_146289_q.func_78269_a(playlistName, this.listWidth - 10);
                    int color = this.isSelected(slotIdx) ? 0xFFFF00 : 0xAADDEE;
                    GuiChunkTool.this.field_146289_q.func_175063_a(trimmedName, (float)this.left + 3.0f, (float)slotTop, color);
                } else {
                    String name = "---GUID Conflict---";
                    String trimmedName = GuiChunkTool.this.field_146289_q.func_78269_a(name, this.listWidth - 10);
                    int color = 0xFF0000;
                    GuiChunkTool.this.field_146289_q.func_175063_a(trimmedName, (float)this.left + 3.0f, (float)slotTop, color);
                }
            }
        };
    }

    public void func_73866_w_() {
        Keyboard.enableRepeatEvents((boolean)false);
        this.guiLeft = (this.field_146294_l - this.xSize) / 2;
        this.guiTop = (this.field_146295_m - this.ySize) / 2;
        this.guiPlayLists.setLayout(this.field_146289_q.field_78288_b + 2, 90, 141, this.guiTop + 12, this.guiTop + 12 + 141, this.guiLeft + 12);
        int widthButtons = 75;
        int posX = this.guiLeft + 154;
        int posY = this.guiTop + 32;
        this.buttonStart = new GuiButtonMX(0, posX, posY, widthButtons, 20, "Start");
        this.buttonEnd = new GuiButtonMX(1, posX, this.buttonStart.field_146129_i + this.buttonStart.field_146121_g, widthButtons, 20, "End");
        this.buttonApply = new GuiButtonMX(2, posX, this.buttonEnd.field_146129_i + this.buttonEnd.field_146121_g, widthButtons, 20, "Apply");
        this.buttonReset = new GuiButtonMX(3, posX, this.buttonApply.field_146129_i + this.buttonApply.field_146121_g, widthButtons, 20, "Reset");
        GuiButton buttonCancel = new GuiButton(4, posX, this.buttonReset.field_146129_i + this.buttonReset.field_146121_g * 2, widthButtons, 20, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0]));
        this.field_146292_n.add(this.buttonStart);
        this.field_146292_n.add(this.buttonEnd);
        this.field_146292_n.add(this.buttonApply);
        this.field_146292_n.add(this.buttonReset);
        this.field_146292_n.add(buttonCancel);
        this.initPlayLists();
        this.reloadState();
    }

    private void reloadState() {
        this.updateButtons();
    }

    private void updateState() {
        this.updateSelected();
        this.updateButtons();
    }

    private void updateButtons() {
        this.buttonApply.field_146124_l = MusicOptionsUtil.getChunkStart(this.player) != null && MusicOptionsUtil.getChunkEnd(this.player) != null && ClientFileManager.getPlayList(MusicOptionsUtil.getSelectedPlayListGuid((EntityPlayer)this.field_146297_k.field_71439_g)) != null;
    }

    private void updateSelected() {
        PlayList selectedPlaylistToApply = ClientFileManager.getPlayList(MusicOptionsUtil.getSelectedPlayListGuid((EntityPlayer)this.field_146297_k.field_71439_g));
        if (selectedPlaylistToApply != null) {
            this.guiPlayLists.stream().filter(selectedPlaylistToApply::equals).forEach(playList -> {
                this.guiPlayLists.setSelectedIndex(this.guiPlayLists.indexOf(playList));
                this.guiPlayLists.resetScroll();
            });
        }
    }

    public boolean func_73868_f() {
        return false;
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.drawGuiBackground();
        String title = I18n.func_135052_a((String)"mxtune.gui.GuiChunkTool.title", (Object[])new Object[0]);
        int posX = this.guiLeft + this.xSize - this.field_146289_q.func_78256_a(title) - 12;
        int posY = this.guiTop + 12;
        this.field_146289_q.func_78256_a(title);
        this.field_146289_q.func_78276_b(title, posX, posY, 0);
        this.guiPlayLists.drawScreen(mouseX, mouseY, partialTicks);
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    protected void func_146284_a(GuiButton guibutton) {
        if (!guibutton.field_146124_l) {
            return;
        }
        switch (guibutton.field_146127_k) {
            case 0: {
                this.setOperation(ChunkToolMessage.Operation.START);
                MusicOptionsUtil.setChunkStart(this.player, this.player.field_70170_p.func_175726_f(this.player.func_180425_c()));
                break;
            }
            case 1: {
                this.setOperation(ChunkToolMessage.Operation.END);
                MusicOptionsUtil.setChunkEnd(this.player, this.player.field_70170_p.func_175726_f(this.player.func_180425_c()));
                break;
            }
            case 2: {
                this.setOperation(ChunkToolMessage.Operation.APPLY);
                break;
            }
            case 3: {
                this.resetOperations();
                break;
            }
            case 4: {
                break;
            }
        }
        this.field_146297_k.func_147108_a(null);
        this.field_146297_k.func_71381_h();
        this.updateState();
    }

    public void func_146274_d() throws IOException {
        int mouseX = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
        int mouseY = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
        this.guiPlayLists.handleMouseInput(mouseX, mouseY);
        super.func_146274_d();
    }

    private void drawGuiBackground() {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.field_71446_o.func_110577_a(guiTexture);
        this.func_73729_b(this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize);
    }

    private void initPlayLists() {
        PacketDispatcher.sendToServer(new GetBaseDataListsMessage(CallBackManager.register((CallBack)ClientFileManager.INSTANCE, this), RecordType.PLAY_LIST));
    }

    private void setOperation(ChunkToolMessage.Operation op) {
        PacketDispatcher.sendToServer(new ChunkToolMessage(op));
    }

    private void resetOperations() {
        PacketDispatcher.sendToServer(new ChunkToolMessage(ChunkToolMessage.Operation.RESET));
        MusicOptionsUtil.setChunkStart(this.player, null);
        MusicOptionsUtil.setChunkEnd(this.player, null);
    }

    @Override
    public void onNotify(@Nonnull RecordType recordType) {
        switch (recordType) {
            case PLAY_LIST: {
                this.guiPlayLists.clear();
                this.guiPlayLists.addAll(SortHelper.PLAYLIST_ORDERING.sortedCopy(ClientFileManager.getPlayLists()));
                break;
            }
        }
        this.updateState();
    }
}

