/*
 * Decompiled with CFR 0.152.
 */
package net.aeronica.mods.mxtune.gui.hud;

public class HudData {
    private final int posX;
    private final int posY;
    private final boolean displayLeft;
    private final boolean displayTop;
    private final Quadrant quadrant;

    public HudData(int posX, int posY, boolean displayLeft, boolean displayTop, Quadrant quadrant) {
        this.posX = posX;
        this.posY = posY;
        this.displayLeft = displayLeft;
        this.displayTop = displayTop;
        this.quadrant = quadrant;
    }

    public int getPosX() {
        return this.posX;
    }

    public int getPosY() {
        return this.posY;
    }

    public Quadrant getQuadrant() {
        return this.quadrant;
    }

    public boolean isDisplayLeft() {
        return this.displayLeft;
    }

    public boolean isDisplayTop() {
        return this.displayTop;
    }

    public boolean isEqual(HudData hudData) {
        return this.posX == hudData.getPosX() && this.posY == hudData.getPosY() && this.displayLeft == hudData.isDisplayLeft() && this.displayTop == hudData.isDisplayTop();
    }

    public int top(int maxHeight) {
        return this.isDisplayTop() ? 0 : -maxHeight;
    }

    public int left(int maxWidth) {
        return this.isDisplayLeft() ? 0 : -maxWidth;
    }

    public int bottom(int maxHeight) {
        return this.isDisplayTop() ? maxHeight : 0;
    }

    public int right(int maxWidth) {
        return this.isDisplayLeft() ? maxWidth : 0;
    }

    public int quadX(int maxWidth, int xIn, int padding, int xSize) {
        if (this.quadrant == Quadrant.I || this.quadrant == Quadrant.IV) {
            return this.left(maxWidth) + xIn + padding + this.left(xSize);
        }
        return this.right(maxWidth) - xIn - padding - xSize;
    }

    public int quadY(int maxHeight, int yIn, int padding, int ySize) {
        if (this.quadrant == Quadrant.III || this.quadrant == Quadrant.IV) {
            return this.top(maxHeight) + yIn + padding + this.top(ySize);
        }
        return this.bottom(maxHeight) - yIn - padding - ySize;
    }

    public static enum Quadrant {
        I,
        II,
        III,
        IV;

    }
}

