/*
 * Decompiled with CFR 0.152.
 */
package net.aeronica.mods.mxtune.gui.hud;

import java.awt.Color;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.aeronica.mods.mxtune.MXTune;
import net.aeronica.mods.mxtune.gui.hud.HudData;
import net.aeronica.mods.mxtune.gui.hud.HudDataFactory;
import net.aeronica.mods.mxtune.gui.hud.HudMouse;
import net.aeronica.mods.mxtune.gui.util.GuiSliderMX;
import net.aeronica.mods.mxtune.network.PacketDispatcher;
import net.aeronica.mods.mxtune.network.server.HudOptionsMessage;
import net.aeronica.mods.mxtune.options.MusicOptionsUtil;
import net.aeronica.mods.mxtune.util.MIDISystemUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.client.config.GuiButtonExt;
import org.lwjgl.input.Mouse;

public class GuiHudAdjust
extends GuiScreen {
    private static final String TITLE = I18n.func_135052_a((String)"mxtune.gui.hudAdjust.title", (Object[])new Object[0]);
    private static final String MIDI_NOT_AVAILABLE = I18n.func_135052_a((String)"mxtune.chat.msu.midiNotAvailable", (Object[])new Object[0]);
    private GuiScreen guiScreenOld;
    private GuiButtonExt buttonCancel;
    private GuiSliderMX sliderHudSize;
    private EntityPlayer playerIn;
    private boolean midiUnavailable;
    private int chosenHudPos;
    private int mouseX;
    private int mouseY;
    private HudMouse hudMouse = new HudMouse();
    private boolean isStateCached = false;
    private int prevHudPos;
    private float prevHudSize;

    public GuiHudAdjust(@Nullable GuiScreen guiScreenIn) {
        this.guiScreenOld = guiScreenIn;
        this.field_146297_k = MXTune.proxy.getMinecraft();
        this.field_146289_q = this.field_146297_k.field_71466_p;
    }

    public void func_73866_w_() {
        this.playerIn = this.field_146297_k.field_71439_g;
        this.midiUnavailable = MIDISystemUtil.midiUnavailable();
        float hudSize = MusicOptionsUtil.getSizeHud(this.playerIn) * 100.0f < 50.0f ? 50.0f : MusicOptionsUtil.getSizeHud(this.playerIn) * 100.0f;
        this.field_146292_n.clear();
        this.chosenHudPos = MusicOptionsUtil.getPositionHUD(this.playerIn);
        int y = this.field_146295_m / 2;
        int buttonWidth = 100;
        int x = this.field_146294_l / 2 - buttonWidth / 2;
        this.sliderHudSize = new GuiSliderMX(2, x, y, buttonWidth, 20, I18n.func_135052_a((String)"mxtune.gui.hudAdjust.size", (Object[])new Object[0]), hudSize, 50.0f, 100.0f, 5.0f);
        GuiButtonExt buttonDone = new GuiButtonExt(0, x, y += 20, buttonWidth, 20, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0]));
        this.buttonCancel = new GuiButtonExt(1, x, y += 20, buttonWidth, 20, I18n.func_135052_a((String)"gui.cancel", (Object[])new Object[0]));
        this.field_146292_n.add(this.buttonCancel);
        this.field_146292_n.add(buttonDone);
        this.field_146292_n.add(this.sliderHudSize);
        this.reloadState();
    }

    private void reloadState() {
        if (!this.isStateCached) {
            return;
        }
        this.sliderHudSize.setValue(this.prevHudSize);
        this.chosenHudPos = this.prevHudPos;
    }

    private void updateState() {
        this.prevHudPos = this.chosenHudPos;
        this.isStateCached = true;
    }

    private void cleanup() {
        MusicOptionsUtil.setAdjustPositionHud(MusicOptionsUtil.getPositionHUD(this.playerIn));
        MusicOptionsUtil.setAdjustSizeHud(MusicOptionsUtil.getSizeHud(this.playerIn));
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        if (button.field_146124_l) {
            switch (button.field_146127_k) {
                case 0: {
                    PacketDispatcher.sendToServer(new HudOptionsMessage(this.chosenHudPos, MusicOptionsUtil.isHudDisabled(this.playerIn), this.sliderHudSize.getValue() / 100.0f));
                    MusicOptionsUtil.setAdjustPositionHud(this.chosenHudPos);
                    MusicOptionsUtil.setAdjustSizeHud(this.sliderHudSize.getValue() / 100.0f);
                    MusicOptionsUtil.setHudOptions(this.playerIn, MusicOptionsUtil.isHudDisabled(this.playerIn), this.chosenHudPos, this.sliderHudSize.getValue() / 100.0f);
                    this.field_146297_k.func_147108_a(this.guiScreenOld);
                    break;
                }
                case 1: {
                    this.cleanup();
                    this.field_146297_k.func_147108_a(this.guiScreenOld);
                    break;
                }
            }
            this.updateState();
        }
        super.func_146284_a(button);
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (keyCode == 1) {
            this.func_146284_a((GuiButton)this.buttonCancel);
            return;
        }
        this.updateState();
        super.func_73869_a(typedChar, keyCode);
    }

    public void func_73876_c() {
        this.prevHudSize = this.sliderHudSize.getValue();
        MusicOptionsUtil.setAdjustSizeHud(this.prevHudSize / 100.0f);
        super.func_73876_c();
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.drawHudPositions();
        String localTITLE = this.midiUnavailable ? TITLE + " - " + TextFormatting.RED + MIDI_NOT_AVAILABLE : TITLE;
        int posX = (this.field_146294_l - this.field_146289_q.func_78256_a(localTITLE)) / 2;
        int posY = 10;
        this.field_146289_q.func_175063_a(localTITLE, (float)posX, (float)posY, 0xD3D3D3);
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    public void func_175273_b(@Nonnull Minecraft mcIn, int w, int h) {
        this.reloadState();
        super.func_175273_b(mcIn, w, h);
    }

    private void drawHudPositions() {
        int height = this.field_146295_m - 40;
        for (int i = 0; i < 8; ++i) {
            HudData hd = HudDataFactory.calcHudPositions(i, this.field_146294_l, height);
            Color color = new Color(0, 255, 255);
            Color darkColor = color.darker();
            GuiHudAdjust.func_73734_a((int)(hd.isDisplayLeft() ? hd.getPosX() + 2 : hd.getPosX() - 2), (int)(hd.isDisplayTop() ? hd.getPosY() + 2 : hd.getPosY() - 2), (int)(hd.isDisplayLeft() ? hd.getPosX() + this.field_146294_l / 5 - 1 : hd.getPosX() - this.field_146294_l / 5 + 1), (int)(hd.isDisplayTop() ? hd.getPosY() + height / 4 - 1 : hd.getPosY() - height / 4 + 1), (int)((i == this.mouseOverHudPos(hd, i).getHudPos() ? color.getRGB() : darkColor.getRGB()) + Integer.MIN_VALUE));
        }
    }

    private HudMouse mouseOverHudPos(HudData hd, int pos) {
        int height = this.field_146295_m - 40;
        if ((hd.isDisplayLeft() ? hd.getPosX() : hd.getPosX() - this.field_146294_l / 5) < this.mouseX && (hd.isDisplayLeft() ? hd.getPosX() + this.field_146294_l / 5 : this.field_146294_l) > this.mouseX && (hd.isDisplayTop() ? hd.getPosY() : hd.getPosY() - height / 4) < this.mouseY && (hd.isDisplayTop() ? hd.getPosY() + height / 4 : hd.getPosY()) > this.mouseY) {
            this.hudMouse.setHudPos(pos);
            this.hudMouse.setMouseX(this.mouseX);
            this.hudMouse.setMouseY(this.mouseY);
            return this.hudMouse;
        }
        return this.hudMouse;
    }

    public void func_146274_d() throws IOException {
        this.mouseX = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
        this.mouseY = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
        super.func_146274_d();
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        if (mouseButton == 0 && this.hudMouse.getHudPos() != -1 && this.hudMouse.getMouseX() == mouseX && this.hudMouse.getMouseY() == mouseY) {
            this.chosenHudPos = this.hudMouse.getHudPos();
            MusicOptionsUtil.setAdjustPositionHud(this.chosenHudPos);
        }
        super.func_73864_a(mouseX, mouseY, mouseButton);
    }

    public boolean func_73868_f() {
        return false;
    }

    public void func_146281_b() {
        this.cleanup();
    }
}

