/*
 * Decompiled with CFR 0.152.
 */
package net.aeronica.mods.mxtune.gui;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.aeronica.mods.mxtune.MXTune;
import net.aeronica.mods.mxtune.managers.GroupHelper;
import net.aeronica.mods.mxtune.network.PacketDispatcher;
import net.aeronica.mods.mxtune.network.server.ManageGroupMessage;
import net.aeronica.mods.mxtune.util.ModLogger;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public class GuiGroup
extends GuiScreen {
    private static final ResourceLocation guiTexture = new ResourceLocation("mxtune", "textures/gui/manage_group.png");
    private int xSize = 239;
    private int ySize = 164;
    private int guiLeft;
    private int guiTop;
    private GuiButton btnCreate;
    private GuiButton btnLeave;
    private List<MemberButtons> memberButtons;
    private EntityPlayer player;

    public void func_73866_w_() {
        Keyboard.enableRepeatEvents((boolean)false);
        this.player = this.field_146297_k.field_71439_g;
        this.guiLeft = (this.field_146294_l - this.xSize) / 2;
        this.guiTop = (this.field_146295_m - this.ySize) / 2;
        this.field_146292_n.clear();
        int posX = this.guiLeft + 169;
        int posY = this.guiTop + 92;
        this.btnCreate = new GuiButton(0, posX, posY, 60, 20, "Create");
        posX = this.guiLeft + 169;
        posY = this.guiTop + 112;
        this.btnLeave = new GuiButton(1, posX, posY, 60, 20, "Leave");
        posX = this.guiLeft + 169;
        posY = this.guiTop + 132;
        GuiButton btnCancel = new GuiButton(2, posX, posY, 60, 20, "Cancel");
        this.initMembersButtons();
        this.field_146292_n.add(this.btnCreate);
        this.field_146292_n.add(this.btnLeave);
        this.field_146292_n.add(btnCancel);
    }

    public boolean func_73868_f() {
        return false;
    }

    public void func_73863_a(int i, int j, float f) {
        this.func_146276_q_();
        this.drawGuiBackground();
        String title = I18n.func_135052_a((String)"mxtune.gui.GuiGroup.title", (Object[])new Object[0]);
        int posX = this.guiLeft + this.xSize - this.field_146289_q.func_78256_a(title) - 12;
        int posY = this.guiTop + 12;
        this.field_146289_q.func_78256_a(title);
        this.field_146289_q.func_78276_b(title, posX, posY, 0);
        this.drawGroupMembers();
        this.btnLeave.field_146124_l = GroupHelper.getMembersGroupID(this.player.func_145782_y()) != -1;
        this.btnCreate.field_146124_l = !this.btnLeave.field_146124_l;
        super.func_73863_a(i, j, f);
    }

    private void initMembersButtons() {
        int posX = this.guiLeft + 104;
        int posY = this.guiTop + 12 + 10;
        int did = 10;
        int pid = 100;
        this.memberButtons = new ArrayList<MemberButtons>();
        for (int i = 0; i < 8; ++i) {
            this.memberButtons.add(i, this.memberButtons(did, pid, posX, posY));
            posY += 10;
            ++did;
            ++pid;
        }
    }

    private void clearMembersButtons() {
        for (int i = 0; i < 8; ++i) {
            this.memberButtons.get((int)i).memberName = "";
            this.memberButtons.get((int)i).buttonRemove.field_146124_l = false;
            this.memberButtons.get((int)i).buttonRemove.field_146125_m = false;
            this.memberButtons.get((int)i).buttonPromote.field_146124_l = false;
            this.memberButtons.get((int)i).buttonPromote.field_146125_m = false;
        }
    }

    private Integer getMemberByButtonID(int buttonID) {
        Integer memberId = -1;
        for (int i = 0; i < 8; ++i) {
            MemberButtons mb = this.memberButtons.get(i);
            if (mb.buttonRemove.field_146127_k != buttonID && mb.buttonPromote.field_146127_k != buttonID) continue;
            memberId = mb.memberId;
        }
        return memberId;
    }

    private void drawGroupMembers() {
        int posX = this.guiLeft + 12;
        int posY = this.guiTop + 12;
        this.clearMembersButtons();
        if (GroupHelper.getClientGroups() != null || GroupHelper.getClientMembers() != null) {
            int groupID = GroupHelper.getMembersGroupID(this.player.func_145782_y());
            int leaderID = GroupHelper.getLeaderOfGroup(groupID);
            if (groupID != -1 && leaderID != -1) {
                this.drawLeader(leaderID, posX, posY);
                this.drawMembers(groupID, leaderID, posX, posY += 10);
            }
        }
    }

    private void drawLeader(Integer leaderID, int posX, int posY) {
        EntityPlayer entityLeader = MXTune.proxy.getPlayerByEntityID(leaderID);
        if (entityLeader != null) {
            String leaderName = entityLeader.func_70005_c_();
            this.field_146289_q.func_175063_a(TextFormatting.YELLOW + leaderName, (float)posX, (float)posY, 0xFFFFFF);
        }
    }

    private void drawMembers(Integer groupID, Integer leaderID, int posX, int posYIn) {
        int i = 0;
        int posY = posYIn;
        Set<Integer> members = GroupHelper.getClientMembers().keySet();
        for (Integer memberId : members) {
            EntityPlayer entityMember = MXTune.proxy.getPlayerByEntityID(memberId);
            if (!groupID.equals(GroupHelper.getMembersGroupID(memberId)) || memberId.equals(leaderID) || entityMember == null) continue;
            String memberName = entityMember.func_70005_c_();
            this.field_146289_q.func_175063_a(memberName, (float)posX, (float)posY, 0xFFFFFF);
            this.memberButtons.get((int)i).memberName = memberName;
            this.memberButtons.get((int)i).memberId = memberId;
            if (this.player.func_145782_y() == leaderID.intValue()) {
                this.memberButtons.get((int)i).buttonRemove.field_146124_l = true;
                this.memberButtons.get((int)i).buttonRemove.field_146125_m = true;
                this.memberButtons.get((int)i).buttonPromote.field_146124_l = true;
                this.memberButtons.get((int)i).buttonPromote.field_146125_m = true;
            }
            posY += 10;
            ++i;
        }
    }

    protected void func_146284_a(GuiButton guibutton) {
        if (!guibutton.field_146124_l) {
            return;
        }
        if (guibutton.field_146127_k >= 10 && guibutton.field_146127_k < 100) {
            this.sendRequest(3, this.getMemberByButtonID(guibutton.field_146127_k));
            ModLogger.debug("+++ Gui Remove Member: 3", new Object[0]);
            return;
        }
        if (guibutton.field_146127_k >= 100) {
            this.sendRequest(4, this.getMemberByButtonID(guibutton.field_146127_k));
            ModLogger.debug("+++ Gui Promote Member: 4", new Object[0]);
            return;
        }
        switch (guibutton.field_146127_k) {
            case 0: {
                this.sendRequest(1, this.player.func_145782_y());
                ModLogger.debug("+++ Gui Create Group: 1", new Object[0]);
                break;
            }
            case 1: {
                this.sendRequest(3, this.player.func_145782_y());
                ModLogger.debug("+++ Gui Leave Group: 3", new Object[0]);
                break;
            }
        }
        this.field_146297_k.func_147108_a(null);
        this.field_146297_k.func_71381_h();
    }

    private void drawGuiBackground() {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.field_71446_o.func_110577_a(guiTexture);
        this.func_73729_b(this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize);
    }

    private void sendRequest(int operation, Integer memberId) {
        PacketDispatcher.sendToServer(new ManageGroupMessage(operation, null, memberId));
    }

    private MemberButtons memberButtons(int deleteId, int promoteId, int xPosition, int yPosition) {
        MemberButtons buttons = new MemberButtons();
        buttons.buttonRemove = new GuiButton(deleteId, xPosition, yPosition, 10, 10, "D");
        buttons.buttonRemove.field_146125_m = false;
        buttons.buttonRemove.field_146124_l = false;
        buttons.buttonPromote = new GuiButton(promoteId, xPosition + 10, yPosition, 10, 10, "L");
        buttons.buttonPromote.field_146125_m = false;
        buttons.buttonPromote.field_146124_l = false;
        this.field_146292_n.add(buttons.buttonRemove);
        this.field_146292_n.add(buttons.buttonPromote);
        return buttons;
    }

    protected class MemberButtons {
        GuiButton buttonRemove;
        GuiButton buttonPromote;
        String memberName;
        Integer memberId;

        protected MemberButtons() {
        }
    }
}

