/*
 * Decompiled with CFR 0.152.
 */
package net.aeronica.mods.mxtune.caches;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import net.aeronica.mods.mxtune.caches.Filter;
import net.aeronica.mods.mxtune.caches.Service;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DirectoryWatcher
implements Runnable,
Service {
    private static final Logger LOGGER = LogManager.getLogger(DirectoryWatcher.class);
    private static final Map<WatchEvent.Kind<Path>, Event> EVENT_MAP = new HashMap<WatchEvent.Kind<Path>, Event>();
    private static final ExecutorService EXECUTOR;
    private Future<?> mWatcherTask;
    private final Set<Path> mWatched;
    private final boolean mPreExistingAsCreated;
    private final Listener mListener;
    private final Filter<Path> mFilter;

    public DirectoryWatcher(Builder builder) {
        this.mWatched = builder.mWatched;
        this.mPreExistingAsCreated = builder.mPreExistingAsCreated;
        this.mListener = builder.mListener;
        this.mFilter = builder.mFilter;
    }

    private static <T> WatchEvent<T> cast(WatchEvent<?> event) {
        return event;
    }

    @Override
    public void start() {
        this.mWatcherTask = EXECUTOR.submit(this);
    }

    @Override
    public void stop() {
        this.mWatcherTask.cancel(true);
        this.mWatcherTask = null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        WatchService watchService;
        try {
            watchService = FileSystems.getDefault().newWatchService();
        }
        catch (IOException ioe) {
            throw new RuntimeException("Exception while creating watch service.", ioe);
        }
        HashMap<WatchKey, Path> watchKeyToDirectory = new HashMap<WatchKey, Path>();
        for (Path dir : this.mWatched) {
            try {
                if (this.mPreExistingAsCreated) {
                    try (DirectoryStream<Path> stream = Files.newDirectoryStream(dir);){
                        for (Path path : stream) {
                            if (!this.mFilter.accept(path)) continue;
                            this.mListener.onEvent(Event.ENTRY_CREATE, dir.resolve(path));
                        }
                    }
                }
                WatchKey key = dir.register(watchService, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_DELETE);
                watchKeyToDirectory.put(key, dir);
            }
            catch (IOException ioe) {
                LOGGER.error("Not watching '{}'.", (Object)dir, (Object)ioe);
            }
        }
        while (true) {
            WatchKey key;
            Path dir;
            if (Thread.interrupted()) {
                LOGGER.info("Directory watcher thread interrupted.");
                return;
            }
            try {
                key = watchService.take();
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                continue;
            }
            dir = (Path)watchKeyToDirectory.get(key);
            if (dir == null) {
                LOGGER.warn("Watch key not recognized.");
                continue;
            }
            for (WatchEvent<?> event : key.pollEvents()) {
                if (event.kind().equals(StandardWatchEventKinds.OVERFLOW)) break;
                WatchEvent pathEvent = DirectoryWatcher.cast(event);
                WatchEvent.Kind kind = pathEvent.kind();
                Path path = dir.resolve((Path)pathEvent.context());
                try {
                    if (!this.mFilter.accept(path) || !EVENT_MAP.containsKey(kind)) continue;
                    this.mListener.onEvent(EVENT_MAP.get(kind), path);
                }
                catch (IOException ioee) {
                    LOGGER.error("Not filtered '{}'.", (Object)dir, (Object)ioee);
                }
            }
            boolean valid = key.reset();
            if (valid) continue;
            watchKeyToDirectory.remove(key);
            LOGGER.warn("'{}' is inaccessible. Stopping watch.", (Object)dir);
            if (watchKeyToDirectory.isEmpty()) return;
        }
    }

    static {
        EVENT_MAP.put(StandardWatchEventKinds.ENTRY_CREATE, Event.ENTRY_CREATE);
        EVENT_MAP.put(StandardWatchEventKinds.ENTRY_MODIFY, Event.ENTRY_MODIFY);
        EVENT_MAP.put(StandardWatchEventKinds.ENTRY_DELETE, Event.ENTRY_DELETE);
        EXECUTOR = Executors.newSingleThreadExecutor();
    }

    public static class Builder {
        private static final Filter<Path> NO_FILTER = path -> true;
        private Set<Path> mWatched = new HashSet<Path>();
        private boolean mPreExistingAsCreated = false;
        private Filter<Path> mFilter = NO_FILTER;
        private Listener mListener;

        public Builder addDirectories(String dirPath) {
            return this.addDirectories(Paths.get(dirPath, new String[0]));
        }

        public Builder addDirectories(Path dirPath) {
            this.mWatched.add(dirPath);
            return this;
        }

        public Builder addDirectories(Path ... dirPaths) {
            Collections.addAll(this.mWatched, dirPaths);
            return this;
        }

        public Builder addDirectories(Iterable<? extends Path> dirPaths) {
            for (Path path : dirPaths) {
                this.mWatched.add(path);
            }
            return this;
        }

        public Builder setPreExistingAsCreated(boolean value) {
            this.mPreExistingAsCreated = value;
            return this;
        }

        public Builder setFilter(Filter<Path> filter) {
            this.mFilter = filter;
            return this;
        }

        public DirectoryWatcher build(Listener listener) {
            this.mListener = listener;
            return new DirectoryWatcher(this);
        }
    }

    public static interface Listener {
        public void onEvent(Event var1, Path var2);
    }

    public static enum Event {
        ENTRY_CREATE,
        ENTRY_MODIFY,
        ENTRY_DELETE;

    }
}

