/*
 * Decompiled with CFR 0.152.
 */
package net.aeronica.mods.mxtune.blocks;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.aeronica.mods.mxtune.blocks.BlockBandAmp;
import net.aeronica.mods.mxtune.blocks.IMusicPlayer;
import net.aeronica.mods.mxtune.blocks.TileInstrument;
import net.aeronica.mods.mxtune.inventory.IInstrument;
import net.aeronica.mods.mxtune.sound.SoundRange;
import net.aeronica.mods.mxtune.util.EnumRelativeSide;
import net.aeronica.mods.mxtune.util.ModLogger;
import net.aeronica.mods.mxtune.util.SheetMusicUtil;
import net.aeronica.mods.mxtune.world.IModLockableContainer;
import net.aeronica.mods.mxtune.world.OwnerUUID;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.LockCode;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileBandAmp
extends TileInstrument
implements IModLockableContainer,
IMusicPlayer {
    public static final int MAX_SLOTS = 12;
    private static final String KEY_CUSTOM_NAME = "CustomName";
    private static final String KEY_POWERED = "powered";
    private static final String KEY_LEFT_RS_OUTPUT_ENABLED = "leftRedstoneOutputEnabled";
    private static final String KEY_REAR_RS_INPUT_ENABLED = "rearRedstoneInputEnabled";
    private static final String KEY_RIGHT_RS_OUTPUT_ENABLED = "rightRedstoneOutputEnabled";
    private static final String KEY_UPDATE_COUNT = "updateCount";
    private boolean previousInputPowerState;
    private int playID;
    private int lastPlayID;
    private LockCode code = LockCode.field_180162_a;
    private OwnerUUID ownerUUID = OwnerUUID.EMPTY_UUID;
    private SoundRange soundRange = SoundRange.NORMAL;
    private String bandAmpCustomName;
    private int duration;
    private boolean rearRedstoneInputEnabled = true;
    private boolean leftRedstoneOutputEnabled = true;
    private boolean rightRedstoneOutputEnabled = true;
    private int updateCount;
    private int prevUpdateCount;

    public TileBandAmp() {
    }

    public TileBandAmp(EnumFacing facing) {
        this.inventory = new InstrumentStackHandler(12);
        this.facing = facing;
        this.playID = -1;
    }

    public void onLoad() {
        this.clearLastPlayID();
        this.setPlayID(-1);
    }

    public int getPlayID() {
        return this.playID;
    }

    public void setPlayID(int playID) {
        this.playID = playID;
        if (this.isPlaying()) {
            this.lastPlayID = this.playID;
        }
    }

    boolean lastPlayIDSuccess() {
        return this.lastPlayID > 0;
    }

    void clearLastPlayID() {
        this.lastPlayID = -1;
    }

    private boolean isPlaying() {
        return this.playID > 0;
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.inventory = new InstrumentStackHandler(12);
        this.inventory.deserializeNBT(tag);
        this.duration = tag.func_74762_e("Duration");
        this.previousInputPowerState = tag.func_74767_n(KEY_POWERED);
        this.code = LockCode.func_180158_b((NBTTagCompound)tag);
        this.ownerUUID = OwnerUUID.fromNBT(tag);
        this.rearRedstoneInputEnabled = tag.func_74767_n(KEY_REAR_RS_INPUT_ENABLED);
        this.leftRedstoneOutputEnabled = tag.func_74767_n(KEY_LEFT_RS_OUTPUT_ENABLED);
        this.rightRedstoneOutputEnabled = tag.func_74767_n(KEY_RIGHT_RS_OUTPUT_ENABLED);
        this.updateCount = tag.func_74762_e(KEY_UPDATE_COUNT);
        this.soundRange = SoundRange.fromNBT(tag);
        if (tag.func_150297_b(KEY_CUSTOM_NAME, 8)) {
            this.bandAmpCustomName = tag.func_74779_i(KEY_CUSTOM_NAME);
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        tag.func_179237_a(this.inventory.serializeNBT());
        tag.func_74757_a(KEY_POWERED, this.previousInputPowerState);
        tag.func_74768_a("Duration", this.duration);
        tag.func_74757_a(KEY_REAR_RS_INPUT_ENABLED, this.rearRedstoneInputEnabled);
        tag.func_74757_a(KEY_LEFT_RS_OUTPUT_ENABLED, this.leftRedstoneOutputEnabled);
        tag.func_74757_a(KEY_RIGHT_RS_OUTPUT_ENABLED, this.rightRedstoneOutputEnabled);
        tag.func_74768_a(KEY_UPDATE_COUNT, this.updateCount);
        this.soundRange.toNBT(tag);
        this.ownerUUID.toNBT(tag);
        if (this.code != null) {
            this.code.func_180157_a(tag);
        }
        if (this.func_145818_k_()) {
            tag.func_74778_a(KEY_CUSTOM_NAME, this.bandAmpCustomName);
        }
        return super.func_189515_b(tag);
    }

    @Override
    public int getDuration() {
        return this.duration;
    }

    public void setDuration(int duration) {
        if (this.duration != duration) {
            this.duration = duration;
            this.markDirtySyncClient();
        }
    }

    @Override
    public SoundRange getSoundRange() {
        return this.soundRange;
    }

    public void setSoundRange(SoundRange soundRange) {
        if (this.soundRange != soundRange) {
            this.soundRange = soundRange;
            this.markDirtySyncClient();
        }
    }

    @Override
    public String getMML() {
        return SheetMusicUtil.getInventoryInstrumentBlockMML(this);
    }

    void logInputPower(BlockPos pos, Block blockIn, BlockPos fromPos) {
        BlockPos vec3i = pos.func_177973_b((Vec3i)fromPos);
        ModLogger.debug("TileBandAmp: Powered from %s's %s face", blockIn.func_176194_O().func_177622_c().func_149732_F(), EnumFacing.func_176737_a((float)vec3i.func_177958_n(), (float)vec3i.func_177956_o(), (float)vec3i.func_177952_p()));
    }

    boolean getPreviousInputState() {
        return this.previousInputPowerState;
    }

    void setPreviousInputState(boolean previousRedStoneState) {
        this.previousInputPowerState = previousRedStoneState;
        this.func_70296_d();
    }

    public boolean isRearRedstoneInputEnabled() {
        return this.rearRedstoneInputEnabled;
    }

    public void setRearRedstoneInputEnabled(boolean rearRedstoneInputEnabled) {
        if (this.rearRedstoneInputEnabled != rearRedstoneInputEnabled) {
            this.rearRedstoneInputEnabled = rearRedstoneInputEnabled;
            this.markDirtySyncClient();
        }
    }

    public boolean isLeftRedstoneOutputEnabled() {
        return this.leftRedstoneOutputEnabled;
    }

    public void setLeftRedstoneOutputEnabled(boolean leftRedstoneOutputEnabled) {
        if (this.leftRedstoneOutputEnabled != leftRedstoneOutputEnabled) {
            this.leftRedstoneOutputEnabled = leftRedstoneOutputEnabled;
            this.markDirtySyncClient();
        }
    }

    public boolean isRightRedstoneOutputEnabled() {
        return this.rightRedstoneOutputEnabled;
    }

    public void setRightRedstoneOutputEnabled(boolean rightRedstoneOutputEnabled) {
        if (this.rightRedstoneOutputEnabled != rightRedstoneOutputEnabled) {
            this.rightRedstoneOutputEnabled = rightRedstoneOutputEnabled;
            this.markDirtySyncClient();
        }
    }

    int getUpdateCount() {
        return this.updateCount;
    }

    private void incrementCount() {
        ++this.updateCount;
        this.updateCount %= 16;
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            ModLogger.debug("TileBandAmp: %s, SEND updateCount: %02d", this.func_174877_v(), this.updateCount);
            this.field_145850_b.func_175704_b(this.field_174879_c, this.field_174879_c);
        }
    }

    private void syncClient() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            this.incrementCount();
            this.field_145850_b.func_180501_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c).func_177226_a((IProperty)BlockBandAmp.UPDATE_COUNT, (Comparable)Integer.valueOf(this.updateCount)), 2);
            this.field_145850_b.func_184138_a(this.func_174877_v(), this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 2);
            this.field_145850_b.func_180497_b(this.field_174879_c, this.func_145838_q(), 0, 0);
        }
    }

    private void markDirtySyncClient() {
        this.syncClient();
        this.func_70296_d();
    }

    void clientSideNotify() {
        if (this.field_145850_b.field_72995_K) {
            int count = (Integer)this.field_145850_b.func_180495_p(this.field_174879_c).func_185899_b((IBlockAccess)this.field_145850_b, this.field_174879_c).func_177229_b((IProperty)BlockBandAmp.UPDATE_COUNT);
            if (this.prevUpdateCount != this.updateCount) {
                ModLogger.debug("TileBandAmp: %s, RECV updateCount: %02d, UPDATE_COUNT: %02d", this.func_174877_v(), this.updateCount, count);
                this.field_145850_b.func_180501_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c).func_177226_a((IProperty)BlockBandAmp.UPDATE_COUNT, (Comparable)Integer.valueOf(this.updateCount)), 1);
                this.field_145850_b.func_175704_b(this.field_174879_c, this.field_174879_c);
                this.prevUpdateCount = this.updateCount;
            }
        }
    }

    public boolean hasCapability(Capability<?> cap, @Nullable EnumFacing side) {
        return this.isSidedInventoryAccessible(side) && cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(cap, side);
    }

    @Override
    public <T> T getCapability(Capability<T> cap, @Nullable EnumFacing side) {
        if (this.isSidedInventoryAccessible(side) && cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.inventory);
        }
        return super.getCapability(cap, side);
    }

    private boolean isSidedInventoryAccessible(@Nullable EnumFacing side) {
        EnumRelativeSide enumRelativeSide = EnumRelativeSide.getRelativeSide(side, this.getFacing());
        return (enumRelativeSide == EnumRelativeSide.TOP && !this.isPlaying() || enumRelativeSide == EnumRelativeSide.BOTTOM && this.isPlaying()) && !this.isLocked();
    }

    @Override
    public boolean isLocked() {
        return this.code != null && !this.code.func_180160_a();
    }

    @Override
    public void setLockCode(LockCode code) {
        if (!this.code.func_180159_b().equals(code.func_180159_b())) {
            this.code = code;
            this.markDirtySyncClient();
        }
    }

    @Override
    public LockCode getLockCode() {
        return this.code;
    }

    @Override
    public boolean isOwner(OwnerUUID ownerUUID) {
        return this.ownerUUID != null && this.ownerUUID.equals(ownerUUID);
    }

    @Override
    public boolean isOwner(EntityPlayer entityPlayer) {
        return this.ownerUUID.getUUID().equals(entityPlayer.getPersistentID());
    }

    @Override
    public void setOwner(OwnerUUID ownerUUID) {
        this.ownerUUID = ownerUUID;
        this.func_70296_d();
    }

    @Override
    public OwnerUUID getOwner() {
        return this.ownerUUID;
    }

    public String func_70005_c_() {
        return this.func_145818_k_() ? this.bandAmpCustomName : "tile.mxtune:band_amp.name";
    }

    public boolean func_145818_k_() {
        return this.bandAmpCustomName != null && !this.bandAmpCustomName.isEmpty();
    }

    void setCustomInventoryName(String customInventoryName) {
        this.bandAmpCustomName = customInventoryName;
    }

    public ITextComponent func_145748_c_() {
        return this.func_145818_k_() ? new TextComponentString(this.func_70005_c_()) : new TextComponentTranslation(this.func_70005_c_(), new Object[0]);
    }

    public boolean isUsableByPlayer(EntityPlayer player) {
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    class InstrumentStackHandler
    extends ItemStackHandler {
        InstrumentStackHandler(int size) {
            super(size);
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            if (stack.func_77973_b() instanceof IInstrument) {
                return super.insertItem(slot, stack, simulate);
            }
            return stack;
        }
    }
}

