/*
 * Decompiled with CFR 0.152.
 */
package net.aeronica.mods.mxtune.blocks;

import java.util.Random;
import javax.annotation.Nullable;
import net.aeronica.mods.mxtune.MXTune;
import net.aeronica.mods.mxtune.blocks.BlockPiano;
import net.aeronica.mods.mxtune.blocks.IMusicPlayer;
import net.aeronica.mods.mxtune.blocks.TileBandAmp;
import net.aeronica.mods.mxtune.config.ModConfig;
import net.aeronica.mods.mxtune.init.ModItems;
import net.aeronica.mods.mxtune.managers.PlayManager;
import net.aeronica.mods.mxtune.util.EnumRelativeSide;
import net.aeronica.mods.mxtune.world.LockableHelper;
import net.aeronica.mods.mxtune.world.OwnerUUID;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.IWorldNameable;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockBandAmp
extends BlockHorizontal
implements IMusicPlayer {
    public static final PropertyBool PLAYING = PropertyBool.func_177716_a((String)"playing");
    public static final PropertyBool POWERED = PropertyBool.func_177716_a((String)"powered");
    public static final PropertyInteger UPDATE_COUNT = PropertyInteger.func_177719_a((String)"update_count", (int)0, (int)15);

    public BlockBandAmp() {
        super(Material.field_151575_d);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)field_185512_D, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)PLAYING, (Comparable)Boolean.FALSE).func_177226_a((IProperty)POWERED, (Comparable)Boolean.FALSE).func_177226_a((IProperty)UPDATE_COUNT, (Comparable)Integer.valueOf(0)));
        this.func_149672_a(SoundType.field_185848_a);
        this.func_149711_c(2.0f);
        this.func_149649_H();
        this.field_149789_z = true;
        this.func_149647_a(MXTune.TAB_MUSIC);
    }

    public int func_149738_a(World worldIn) {
        return 10;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return ModItems.ITEM_BAND_AMP;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!worldIn.field_72995_K) {
            if (this.invertSneakIfLocked(playerIn, worldIn, pos) || LockableHelper.isLocked(playerIn, worldIn, pos)) {
                boolean isPlaying = this.canPlayOrStopMusic(worldIn, pos, false);
                this.setPlayingState(worldIn, pos, state, isPlaying);
                worldIn.func_175684_a(pos, (Block)this, this.func_149738_a(worldIn));
            } else if (!this.invertSneakIfLocked(playerIn, worldIn, pos) && playerIn.field_71075_bZ.field_75099_e) {
                playerIn.openGui((Object)MXTune.instance, 5, worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            }
        }
        return true;
    }

    private boolean invertSneakIfLocked(EntityPlayer playerIn, World worldIn, BlockPos pos) {
        return LockableHelper.isLocked((EntityPlayer)FakePlayerFactory.getMinecraft((WorldServer)((WorldServer)worldIn)), worldIn, pos) != playerIn.func_70093_af();
    }

    private boolean canPlayOrStopMusic(World worldIn, BlockPos pos, Boolean stop) {
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (tileEntity instanceof TileBandAmp) {
            TileBandAmp tileBandAmp = (TileBandAmp)tileEntity;
            if (PlayManager.isActivePlayID(tileBandAmp.getPlayID())) {
                PlayManager.stopPlayID(tileBandAmp.getPlayID());
                tileBandAmp.setPlayID(-1);
                return false;
            }
            if (!stop.booleanValue()) {
                int playID = PlayManager.playMusic(worldIn, pos);
                tileBandAmp.setPlayID(playID);
            }
        }
        return true;
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        TileEntity tileEntity;
        if (!worldIn.field_72995_K && (tileEntity = worldIn.func_175625_s(pos)) instanceof TileBandAmp) {
            TileBandAmp tileBandAmp = (TileBandAmp)tileEntity;
            if (((Boolean)state.func_177229_b((IProperty)PLAYING)).booleanValue()) {
                if (!PlayManager.isActivePlayID(tileBandAmp.getPlayID())) {
                    this.setPlayingState(worldIn, pos, state, false);
                    tileBandAmp.setPlayID(-1);
                }
                worldIn.func_175684_a(pos, (Block)this, this.func_149738_a(worldIn));
            } else {
                this.onePulseOutputState(worldIn, pos, state, tileBandAmp);
            }
        }
    }

    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if (!worldIn.func_175667_e(pos)) {
            return;
        }
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (tileEntity instanceof TileBandAmp) {
            TileBandAmp tileBandAmp = (TileBandAmp)tileEntity;
            tileBandAmp.clientSideNotify();
        }
    }

    private void onePulseOutputState(World worldIn, BlockPos pos, IBlockState state, TileBandAmp tileBandAmp) {
        if (!((Boolean)state.func_177229_b((IProperty)POWERED)).booleanValue() && tileBandAmp.lastPlayIDSuccess()) {
            this.setOutputPowerState(worldIn, pos, state, true);
            worldIn.func_175684_a(pos, (Block)this, this.func_149738_a(worldIn));
            tileBandAmp.clearLastPlayID();
        } else if (((Boolean)state.func_177229_b((IProperty)POWERED)).booleanValue()) {
            this.setOutputPowerState(worldIn, pos, state, false);
        }
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        boolean inSidePowered = worldIn.func_175709_b(pos.func_177972_a(((EnumFacing)state.func_177229_b((IProperty)field_185512_D)).func_176734_d()), ((EnumFacing)state.func_177229_b((IProperty)field_185512_D)).func_176734_d());
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (tileEntity instanceof TileBandAmp) {
            TileBandAmp tileBandAmp = (TileBandAmp)tileEntity;
            boolean inputEnabled = tileBandAmp.isRearRedstoneInputEnabled();
            if (tileBandAmp.getPreviousInputState() != inSidePowered && inputEnabled) {
                if (inSidePowered) {
                    boolean isPlaying = this.canPlayOrStopMusic(worldIn, pos, false);
                    this.setPlayingState(worldIn, pos, state, isPlaying);
                    worldIn.func_175684_a(pos, (Block)this, this.func_149738_a(worldIn));
                }
                tileBandAmp.setPreviousInputState(inSidePowered);
            }
        }
    }

    private void setPlayingState(World worldIn, BlockPos posIn, IBlockState state, boolean playing) {
        boolean currentPlayingState = (Boolean)state.func_177229_b((IProperty)PLAYING);
        if (currentPlayingState != playing) {
            worldIn.func_180501_a(posIn, worldIn.func_180495_p(posIn).func_177226_a((IProperty)PLAYING, (Comparable)Boolean.valueOf(playing)), 2);
            worldIn.func_175704_b(posIn, posIn);
        }
    }

    private void setOutputPowerState(World worldIn, BlockPos posIn, IBlockState state, boolean outputPowerState) {
        boolean currentOutputPowerState = (Boolean)state.func_177229_b((IProperty)POWERED);
        if (currentOutputPowerState != outputPowerState) {
            worldIn.func_180501_a(posIn, worldIn.func_180495_p(posIn).func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(outputPowerState)), 3);
            worldIn.func_175704_b(posIn, posIn);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149750_m(IBlockState state) {
        return MinecraftForgeClient.getRenderLayer() == BlockRenderLayer.SOLID && (Boolean)state.func_177229_b((IProperty)PLAYING) != false && ModConfig.isBandAmpFullBrightEffectEnabled() ? 15 : super.func_149750_m(state);
    }

    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        return layer == BlockRenderLayer.SOLID || layer == BlockRenderLayer.TRANSLUCENT;
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)field_185512_D, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)field_185512_D)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)field_185512_D)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{field_185512_D, PLAYING, POWERED, UPDATE_COUNT});
    }

    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)field_185512_D, (Comparable)placer.func_174811_aO().func_176734_d()).func_177226_a((IProperty)PLAYING, (Comparable)Boolean.FALSE).func_177226_a((IProperty)POWERED, (Comparable)Boolean.FALSE).func_177226_a((IProperty)UPDATE_COUNT, (Comparable)Integer.valueOf(0));
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        this.func_176223_P().func_177226_a((IProperty)field_185512_D, (Comparable)placer.func_174811_aO().func_176734_d()).func_177226_a((IProperty)PLAYING, (Comparable)Boolean.FALSE).func_177226_a((IProperty)POWERED, (Comparable)Boolean.FALSE).func_177226_a((IProperty)UPDATE_COUNT, (Comparable)Integer.valueOf(0));
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (tileEntity instanceof TileBandAmp) {
            TileBandAmp tileBandAmp = (TileBandAmp)tileEntity;
            OwnerUUID ownerUUID = new OwnerUUID(placer.getPersistentID());
            tileBandAmp.setOwner(ownerUUID);
            if (stack.func_82837_s()) {
                tileBandAmp.setCustomInventoryName(stack.func_82833_r());
            }
        }
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        TileEntity tileEntity = worldIn instanceof ChunkCache ? ((ChunkCache)worldIn).func_190300_a(pos, Chunk.EnumCreateEntityType.CHECK) : worldIn.func_175625_s(pos);
        int count = 0;
        if (tileEntity instanceof TileBandAmp) {
            TileBandAmp tileBandAmp = (TileBandAmp)tileEntity;
            count = tileBandAmp.getUpdateCount();
        }
        return super.func_176221_a(state, worldIn, pos).func_177226_a((IProperty)UPDATE_COUNT, (Comparable)Integer.valueOf(count));
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing enumfacing = EnumFacing.func_176731_b((int)(meta & 3));
        return this.func_176223_P().func_177226_a((IProperty)field_185512_D, (Comparable)enumfacing).func_177226_a((IProperty)PLAYING, (Comparable)Boolean.valueOf((meta & 8) > 0)).func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf((meta & 4) > 0));
    }

    public int func_176201_c(IBlockState state) {
        int i = 0;
        i |= ((EnumFacing)state.func_177229_b((IProperty)field_185512_D)).func_176736_b();
        if (((Boolean)state.func_177229_b((IProperty)POWERED)).booleanValue()) {
            i |= 4;
        }
        if (((Boolean)state.func_177229_b((IProperty)PLAYING)).booleanValue()) {
            i |= 8;
        }
        return i;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileBandAmp((EnumFacing)state.func_177229_b((IProperty)field_185512_D));
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        this.canPlayOrStopMusic(worldIn, pos, true);
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (tileEntity instanceof TileBandAmp) {
            TileBandAmp tileBandAmp = (TileBandAmp)tileEntity;
            for (int slot = 0; slot < tileBandAmp.getInventory().getSlots(); ++slot) {
                BlockPiano.spawnEntityItem(worldIn, tileBandAmp.getInventory().getStackInSlot(slot), pos);
            }
            tileBandAmp.func_145843_s();
        }
        worldIn.func_175685_c(pos, (Block)this, false);
        super.func_180663_b(worldIn, pos, state);
    }

    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, ItemStack stack) {
        if (te instanceof IWorldNameable && ((IWorldNameable)te).func_145818_k_()) {
            player.func_71020_j(0.005f);
            if (worldIn.field_72995_K) {
                return;
            }
            int i = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)stack);
            Item item = this.func_180660_a(state, worldIn.field_73012_v, i);
            if (item == Items.field_190931_a) {
                return;
            }
            ItemStack itemstack = new ItemStack(item, this.func_149745_a(worldIn.field_73012_v));
            itemstack.func_151001_c(((IWorldNameable)te).func_70005_c_());
            BlockBandAmp.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)itemstack);
        } else {
            super.func_180657_a(worldIn, player, pos, state, null, stack);
        }
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        EnumRelativeSide relativeSide = EnumRelativeSide.getRelativeSide(face, (EnumFacing)state.func_177229_b((IProperty)field_185512_D));
        return relativeSide == EnumRelativeSide.LEFT || relativeSide == EnumRelativeSide.RIGHT ? BlockFaceShape.UNDEFINED : BlockFaceShape.SOLID;
    }

    public boolean canConnectRedstone(IBlockState state, IBlockAccess world, BlockPos pos, @Nullable EnumFacing side) {
        TileEntity tileEntity;
        boolean canConnect = false;
        if (side != null && (tileEntity = world.func_175625_s(pos)) instanceof TileBandAmp) {
            TileBandAmp tileBandAmp = (TileBandAmp)tileEntity;
            EnumRelativeSide relativeSide = EnumRelativeSide.getRelativeSide(side.func_176734_d(), (EnumFacing)state.func_177229_b((IProperty)field_185512_D));
            boolean canConnectBack = tileBandAmp.isRearRedstoneInputEnabled() && relativeSide == EnumRelativeSide.BACK;
            boolean canConnectLeft = tileBandAmp.isLeftRedstoneOutputEnabled() && relativeSide == EnumRelativeSide.LEFT;
            boolean canConnectRight = tileBandAmp.isRightRedstoneOutputEnabled() && relativeSide == EnumRelativeSide.RIGHT;
            canConnect = canConnectBack || canConnectLeft || canConnectRight;
        }
        return canConnect;
    }

    public boolean func_149744_f(IBlockState state) {
        return true;
    }

    public int func_180656_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        int weakPower = 0;
        TileEntity tileEntity = blockAccess.func_175625_s(pos);
        if (tileEntity instanceof TileBandAmp) {
            TileBandAmp tileBandAmp = (TileBandAmp)tileEntity;
            EnumRelativeSide relativeSide = EnumRelativeSide.getRelativeSide(side.func_176734_d(), (EnumFacing)blockState.func_177229_b((IProperty)field_185512_D));
            boolean canConnectLeft = tileBandAmp.isLeftRedstoneOutputEnabled() && relativeSide == EnumRelativeSide.LEFT;
            boolean canConnectRight = tileBandAmp.isRightRedstoneOutputEnabled() && relativeSide == EnumRelativeSide.RIGHT;
            weakPower = (Boolean)blockState.func_177229_b((IProperty)POWERED) != false && (canConnectLeft || canConnectRight) ? 15 : 0;
        }
        return weakPower;
    }

    public int func_176211_b(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return blockState.func_185911_a(blockAccess, pos, side);
    }
}

