/*
 * Decompiled with CFR 0.152.
 */
package net.aeronica.mods.mxtune.advancements.criterion;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.advancements.ICriterionTrigger;
import net.minecraft.advancements.PlayerAdvancements;
import net.minecraft.advancements.critereon.AbstractCriterionInstance;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;

public class PlayInstrumentTrigger
implements ICriterionTrigger<Instance> {
    private static final ResourceLocation ID = new ResourceLocation("mxtune", "play_instrument");
    private final Map<PlayerAdvancements, Listeners> listeners = new HashMap<PlayerAdvancements, Listeners>();

    public ResourceLocation func_192163_a() {
        return ID;
    }

    public void func_192165_a(PlayerAdvancements playerAdvancementsIn, ICriterionTrigger.Listener<Instance> listener) {
        this.listeners.computeIfAbsent(playerAdvancementsIn, Listeners::new).add(listener);
    }

    public void func_192164_b(PlayerAdvancements playerAdvancementsIn, ICriterionTrigger.Listener<Instance> listener) {
        Listeners ls = this.listeners.get(playerAdvancementsIn);
        if (ls != null) {
            ls.remove(listener);
            if (ls.isEmpty()) {
                this.listeners.remove(playerAdvancementsIn);
            }
        }
    }

    public void func_192167_a(PlayerAdvancements playerAdvancementsIn) {
        this.listeners.remove(playerAdvancementsIn);
    }

    public void trigger(EntityPlayerMP player, String instrumentName) {
        Listeners ls = this.listeners.get(player.func_192039_O());
        if (ls != null) {
            ls.trigger(instrumentName);
        }
    }

    public Instance deserializeInstance(JsonObject json, JsonDeserializationContext context) {
        String instrumentName = JsonUtils.func_151200_h((JsonObject)json, (String)"instrument");
        if (instrumentName == null) {
            throw new JsonSyntaxException("Unknown instrument: '" + instrumentName + "'");
        }
        return new Instance(instrumentName);
    }

    static class Listeners {
        private final PlayerAdvancements playerAdvancements;
        private final Set<ICriterionTrigger.Listener<Instance>> listenerSet = new HashSet<ICriterionTrigger.Listener<Instance>>();

        public Listeners(PlayerAdvancements playerAdvancements) {
            this.playerAdvancements = playerAdvancements;
        }

        public boolean isEmpty() {
            return this.listenerSet.isEmpty();
        }

        public void add(ICriterionTrigger.Listener<Instance> listener) {
            this.listenerSet.add(listener);
        }

        public void remove(ICriterionTrigger.Listener<Instance> listener) {
            this.listenerSet.remove(listener);
        }

        public void trigger(String instrumentName) {
            ((ImmutableList)this.listenerSet.stream().filter(listener -> ((Instance)listener.func_192158_a()).test(instrumentName)).collect(ImmutableList.toImmutableList())).forEach(listener -> listener.func_192159_a(this.playerAdvancements));
        }
    }

    static class Instance
    extends AbstractCriterionInstance {
        private final String instrumentName;

        Instance(String instrumentName) {
            super(ID);
            this.instrumentName = instrumentName;
        }

        boolean test(String instrumentName) {
            return this.instrumentName.equals(instrumentName);
        }
    }
}

