/*
 * Decompiled with CFR 0.152.
 */
package net.aeronica.mods.mxtune;

import net.aeronica.mods.mxtune.advancements.ModCriteriaTriggers;
import net.aeronica.mods.mxtune.caches.FileHelper;
import net.aeronica.mods.mxtune.cmds.CommandMxTuneServerUpdate;
import net.aeronica.mods.mxtune.cmds.CommandSoundRange;
import net.aeronica.mods.mxtune.handler.GUIHandler;
import net.aeronica.mods.mxtune.init.ModItems;
import net.aeronica.mods.mxtune.managers.DurationTimer;
import net.aeronica.mods.mxtune.managers.ServerFileManager;
import net.aeronica.mods.mxtune.network.MultiPacketSerializedObjectManager;
import net.aeronica.mods.mxtune.network.PacketDispatcher;
import net.aeronica.mods.mxtune.options.PlayerMusicOptionsCapability;
import net.aeronica.mods.mxtune.proxy.ServerProxy;
import net.aeronica.mods.mxtune.util.CallBackManager;
import net.aeronica.mods.mxtune.util.ModLogger;
import net.aeronica.mods.mxtune.util.MusicTab;
import net.aeronica.mods.mxtune.world.caps.chunk.ModChunkPlaylistCap;
import net.aeronica.mods.mxtune.world.caps.world.ModWorldPlaylistCap;
import net.minecraft.command.ICommand;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLFingerprintViolationEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;

@Mod(modid="mxtune", name="mxTune", useMetadata=true, acceptedMinecraftVersions="[1.12.2,1.13)", certificateFingerprint="999640c365a8443393a1a21df2c0ede9488400e9")
public class MXTune {
    @Mod.Instance(value="mxtune")
    public static MXTune instance;
    @SidedProxy(clientSide="net.aeronica.mods.mxtune.proxy.ClientProxy", serverSide="net.aeronica.mods.mxtune.proxy.ServerProxy")
    public static ServerProxy proxy;
    public static final CreativeTabs TAB_MUSIC;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)this);
        ModLogger.setLogger(event.getModLog());
        ModCriteriaTriggers.init();
        ModWorldPlaylistCap.register();
        ModChunkPlaylistCap.register();
        PlayerMusicOptionsCapability.register();
        PacketDispatcher.registerPackets();
        proxy.preInit();
        proxy.registerEventHandlers();
        proxy.initEntities();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        proxy.init();
        proxy.registerKeyBindings();
        proxy.initMML();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)GUIHandler.getInstance());
        FurnaceRecipes.func_77602_a().func_151396_a(new ItemStack((Item)ModItems.ITEM_MUSIC_PAPER).func_77973_b(), new ItemStack(Items.field_151121_aF, 1), 1.0f);
        FurnaceRecipes.func_77602_a().func_151396_a(new ItemStack((Item)ModItems.ITEM_INGREDIENTS, 1, 1).func_77973_b(), new ItemStack(Items.field_151044_h, 1, 1), 1.0f);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        proxy.postInit();
        proxy.registerHUD();
    }

    @Mod.EventHandler
    public void onEvent(FMLFingerprintViolationEvent event) {
        FMLLog.warning((String)"*** [mxTune] Invalid fingerprint detected! ***", (Object[])new Object[0]);
    }

    @Mod.EventHandler
    public void onEvent(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandSoundRange());
        event.registerServerCommand((ICommand)new CommandMxTuneServerUpdate());
        CallBackManager.start();
        MultiPacketSerializedObjectManager.start();
        DurationTimer.start();
        FileHelper.initialize();
        ServerFileManager.start();
    }

    @Mod.EventHandler
    public void onEvent(FMLServerStoppingEvent event) {
        DurationTimer.shutdown();
        ServerFileManager.shutdown();
        CallBackManager.shutdown();
        MultiPacketSerializedObjectManager.shutdown();
    }

    @SubscribeEvent
    void onEvent(FMLNetworkEvent.ClientConnectedToServerEvent event) {
        proxy.clientConnect(event);
    }

    @SubscribeEvent
    void onEvent(FMLNetworkEvent.ClientDisconnectionFromServerEvent event) {
        proxy.clientDisconnect(event);
    }

    static {
        TAB_MUSIC = new MusicTab(CreativeTabs.getNextID(), "mxTune");
    }
}

