/*
 * Decompiled with CFR 0.152.
 */
package net.aeronica.libs.mml.readers.ms2mml;

import com.google.common.io.Files;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import net.aeronica.libs.mml.readers.ms2mml.Ms2;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TestMs2Mml {
    private static final Logger LOGGER = LogManager.getLogger();

    public static String viewMs2Mml(InputStream is) throws JAXBException {
        JAXBContext jaxbContext = JAXBContext.newInstance((String)"net.aeronica.libs.mml.readers.ms2mml");
        Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
        Ms2 ms2 = (Ms2)unmarshaller.unmarshal(is);
        StringBuilder builder = new StringBuilder("MML@");
        builder.append(ms2.melody);
        LOGGER.info("Melody {}", (Object)ms2.melody);
        if (ms2.chord != null) {
            for (Ms2.Chord chord : ms2.chord) {
                String chordValue = chord.value;
                if (chordValue.equals("")) continue;
                builder.append(",");
                builder.append(chordValue);
                LOGGER.info("Chord {}: {}", (Object)chord.index, (Object)chordValue);
            }
        }
        builder.append(";");
        return builder.toString();
    }

    public static FileInputStream getFile(String path) {
        FileInputStream is = null;
        File initialFile = new File(path);
        LOGGER.info("---- File: {}", (Object)initialFile.getName().substring(initialFile.getName().lastIndexOf("\\") + 1));
        try {
            is = new FileInputStream(initialFile);
        }
        catch (FileNotFoundException e) {
            LOGGER.error((Object)e);
        }
        return is;
    }

    public static String viewZipFileContents(String path) {
        StringBuilder builder = new StringBuilder();
        try (ZipFile file = new ZipFile(path);){
            Enumeration<? extends ZipEntry> entries = file.entries();
            LOGGER.info("---- Zip File: {}", (Object)file.getName().substring(file.getName().lastIndexOf("\\") + 1));
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (entry.isDirectory()) continue;
                LOGGER.info("Ext: {}, File: {}, size: {}", (Object)Files.getFileExtension((String)entry.getName()), (Object)entry.getName(), (Object)entry.getSize());
                InputStream is = file.getInputStream(entry);
                builder.append(TestMs2Mml.viewMs2Mml(is));
            }
        }
        catch (IOException | JAXBException e) {
            LOGGER.error((Object)e);
        }
        return builder.toString();
    }

    public static void main(String[] args) throws Exception {
        TestMs2Mml.viewMs2Mml(TestMs2Mml.getFile("E:\\Users\\Paul\\Downloads\\darling-in-the-franxx-ed5-escape-r2518.ms2mml"));
        TestMs2Mml.viewZipFileContents("E:\\Users\\Paul\\Downloads\\undertale-megalovania-r48.zip");
        TestMs2Mml.viewZipFileContents("E:\\Users\\Paul\\Downloads\\kingdom-hearts-3-dont-think-twice-chikai-kyle-landry-version.zip");
        TestMs2Mml.viewMs2Mml(TestMs2Mml.getFile("E:\\Users\\Paul\\Downloads\\killerblood-run-lads-run-r8.ms2mml"));
        TestMs2Mml.viewZipFileContents("E:\\Users\\Paul\\Downloads\\tokyo-ghoul-unravel-r11.zip");
    }
}

