/*
 * Decompiled with CFR 0.152.
 */
package net.aeronica.libs.mml.readers.ms2mml;

import java.io.InputStream;
import java.nio.file.Path;
import javax.annotation.Nonnull;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import net.aeronica.libs.mml.readers.AbstractMmlFileReader;
import net.aeronica.libs.mml.readers.ms2mml.Ms2;

public class Ms2MmlReader
extends AbstractMmlFileReader {
    @Override
    public String getFileExtension() {
        return "ms2mml";
    }

    @Override
    public boolean parseFile(@Nonnull Path path) {
        this.readMs2Mml(this.getFile(path));
        return !this.hasErrors();
    }

    @Override
    public boolean parseStream(InputStream is) {
        this.readMs2Mml(is);
        return !this.hasErrors();
    }

    @Override
    public String getMML() {
        return this.mml;
    }

    private void readMs2Mml(InputStream is) {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((String)"net.aeronica.libs.mml.readers.ms2mml");
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            Ms2 ms2 = (Ms2)unmarshaller.unmarshal(is);
            if (ms2 != null) {
                StringBuilder builder = new StringBuilder("MML@");
                String melodyValue = ms2.melody;
                if (!melodyValue.equals("")) {
                    builder.append(melodyValue);
                }
                if (ms2.chord != null) {
                    for (Ms2.Chord chord : ms2.chord) {
                        String chordValue = chord.value;
                        if (chordValue.equals("")) continue;
                        builder.append(",");
                        builder.append(chordValue);
                    }
                }
                builder.append(";");
                this.mml = builder.toString();
            }
        }
        catch (JAXBException e) {
            this.addError(e.getLocalizedMessage());
            this.mml = "";
        }
    }
}

