/*
 * Decompiled with CFR 0.152.
 */
package net.aeronica.libs.mml.readers.ms2mml;

import com.google.common.collect.ImmutableMap;
import java.util.Locale;

public class MapMS2Instruments {
    private static final ImmutableMap<String, String> ms2name2ID;
    private static final String META_CHARACTERS = "abcdefghijklmnopqrstuvwxyz0123456789.-";

    private MapMS2Instruments() {
    }

    public static String getSoundFontProxyNameFromMeta(String metaName) {
        return (String)ms2name2ID.getOrDefault((Object)MapMS2Instruments.cleanupMeta(metaName), (Object)"piano");
    }

    private static String cleanupMeta(String metaName) {
        String working = metaName.toLowerCase(Locale.ENGLISH);
        working = MapMS2Instruments.filterAllowedMetaCharacters(working);
        return working.replaceAll("(([A-Za-z\\-\\d]*).-)|([\\d].)|([.].+)", "");
    }

    public static boolean isAllowedMetaCharacter(char character) {
        char[] ca;
        for (char c : ca = META_CHARACTERS.toCharArray()) {
            if (character != c) continue;
            return true;
        }
        return false;
    }

    public static String filterAllowedMetaCharacters(String input) {
        StringBuilder stringbuilder = new StringBuilder();
        for (char c0 : input.toCharArray()) {
            if (!MapMS2Instruments.isAllowedMetaCharacter(c0)) continue;
            stringbuilder.append(c0);
        }
        return stringbuilder.toString();
    }

    static {
        ImmutableMap.Builder builderByIndex = ImmutableMap.builder();
        builderByIndex.put((Object)"acousticbass", (Object)"bass_acoustic");
        builderByIndex.put((Object)"acousticbassguitar", (Object)"bass_acoustic");
        builderByIndex.put((Object)"acousticguitar", (Object)"guitar_nylon");
        builderByIndex.put((Object)"bassdrum", (Object)"drum_bass_mabinogi");
        builderByIndex.put((Object)"bassguitar", (Object)"bass_fingered");
        builderByIndex.put((Object)"celesta", (Object)"celesta");
        builderByIndex.put((Object)"cello", (Object)"cello");
        builderByIndex.put((Object)"clarinet", (Object)"clarinet");
        builderByIndex.put((Object)"cymbals", (Object)"cymbals_mabinogi");
        builderByIndex.put((Object)"eguitar", (Object)"guitar_overdrive");
        builderByIndex.put((Object)"electricguitar", (Object)"guitar_overdrive");
        builderByIndex.put((Object)"electricpiano", (Object)"piano_electric");
        builderByIndex.put((Object)"epiano", (Object)"piano_electric");
        builderByIndex.put((Object)"guitar", (Object)"guitar_nylon");
        builderByIndex.put((Object)"harmonica", (Object)"harmonica");
        builderByIndex.put((Object)"harp", (Object)"harp");
        builderByIndex.put((Object)"harpsichord", (Object)"harpsichord");
        builderByIndex.put((Object)"oboe", (Object)"oboe");
        builderByIndex.put((Object)"ocarina", (Object)"ocarina");
        builderByIndex.put((Object)"panflute", (Object)"flute_pan");
        builderByIndex.put((Object)"piano", (Object)"piano");
        builderByIndex.put((Object)"pickbassguitar", (Object)"bass_pick");
        builderByIndex.put((Object)"pizzicativiolin", (Object)"pizzicato_string");
        builderByIndex.put((Object)"pizzicatoviolin", (Object)"pizzicato_string");
        builderByIndex.put((Object)"pizziviolin", (Object)"pizzicato_string");
        builderByIndex.put((Object)"recorder", (Object)"recorder");
        builderByIndex.put((Object)"saxophone", (Object)"sax_alto");
        builderByIndex.put((Object)"snaredrum", (Object)"drum_snare_mabinogi");
        builderByIndex.put((Object)"steeldrum", (Object)"drums_steel");
        builderByIndex.put((Object)"timpani", (Object)"timpani");
        builderByIndex.put((Object)"tomtom", (Object)"drums_melodic_tom");
        builderByIndex.put((Object)"trombone", (Object)"trombone");
        builderByIndex.put((Object)"trumpet", (Object)"trumpet");
        builderByIndex.put((Object)"vibraphone", (Object)"vibraphone");
        builderByIndex.put((Object)"violin", (Object)"violin");
        builderByIndex.put((Object)"xylophone", (Object)"xylophone");
        ms2name2ID = builderByIndex.build();
    }
}

