/*
 * Decompiled with CFR 0.152.
 */
package net.aeronica.libs.mml.readers.mml3mle;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.LinkedList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class SectionContents {
    private static final Logger LOGGER = LogManager.getLogger();
    private final String name;
    private final StringBuilder buffer = new StringBuilder();

    private SectionContents(String name) {
        this.name = name;
    }

    public static List<SectionContents> makeSectionContentsByInputStream(InputStream istream) {
        return SectionContents.makeSectionContentsByInputStream(istream, "UTF-8");
    }

    public String getName() {
        return this.name;
    }

    public String getContents() {
        return this.buffer.toString();
    }

    public static List<SectionContents> makeSectionContentsByInputStream(InputStream istream, String charsetName) {
        LinkedList<SectionContents> contentsList = new LinkedList<SectionContents>();
        try {
            InputStreamReader reader = new InputStreamReader(istream, charsetName);
            new BufferedReader(reader).lines().forEach(s -> {
                if (s.startsWith("[")) {
                    contentsList.add(new SectionContents((String)s));
                } else if (!contentsList.isEmpty()) {
                    SectionContents section = (SectionContents)contentsList.getLast();
                    section.buffer.append((String)s).append('\n');
                }
            });
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error((Object)e);
        }
        return contentsList;
    }
}

