/*
 * Decompiled with CFR 0.152.
 */
package net.aeronica.libs.mml.readers;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;

public abstract class AbstractMmlFileReader {
    private Set<String> collectedErrors = new HashSet<String>();
    protected String title = "";
    protected String author = "";
    protected String url = "";
    protected String mml = "";

    public abstract boolean parseFile(Path var1);

    public abstract boolean parseStream(InputStream var1);

    public abstract String getFileExtension();

    public String getTitle() {
        return this.title;
    }

    public String getAuthor() {
        return this.author;
    }

    public String getUrl() {
        return this.url;
    }

    public abstract String getMML();

    public boolean hasErrors() {
        return !this.collectedErrors.isEmpty();
    }

    public String[] getErrorMessages() {
        return this.collectedErrors.toArray(new String[0]);
    }

    protected void addError(String message) {
        this.collectedErrors.add(message);
    }

    @Nullable
    protected FileInputStream getFile(@Nullable Path path) {
        FileInputStream is = null;
        if (path != null) {
            try {
                is = new FileInputStream(path.toFile());
            }
            catch (FileNotFoundException e) {
                this.collectedErrors.add(e.getLocalizedMessage());
            }
            return is;
        }
        this.collectedErrors.add("Path is null in AbstractMmlFileReader#getFile");
        return null;
    }
}

