/*
 * Decompiled with CFR 0.152.
 */
package net.aeronica.libs.mml.parser;

import net.aeronica.libs.mml.util.DataByteBuffer;
import net.aeronica.libs.mml.util.IndexBuffer;

public class MMLLexer {
    private int position = 0;
    private int elementIndex = 0;

    public void parse(DataByteBuffer buffer, IndexBuffer elementBuffer) {
        this.position = 0;
        this.elementIndex = 0;
        while (this.position < buffer.getLength()) {
            switch (buffer.getByte(this.position)) {
                case 73: 
                case 105: {
                    this.setElementDataLength(elementBuffer, this.elementIndex++, (byte)1, this.position);
                    break;
                }
                case 80: 
                case 112: {
                    this.setElementDataLength(elementBuffer, this.elementIndex++, (byte)4, this.position);
                    break;
                }
                case 83: 
                case 115: {
                    this.setElementDataLength(elementBuffer, this.elementIndex++, (byte)5, this.position);
                    break;
                }
                case 84: 
                case 116: {
                    this.setElementDataLength(elementBuffer, this.elementIndex++, (byte)6, this.position);
                    break;
                }
                case 79: 
                case 111: {
                    this.setElementDataLength(elementBuffer, this.elementIndex++, (byte)3, this.position);
                    break;
                }
                case 86: 
                case 118: {
                    this.setElementDataLength(elementBuffer, this.elementIndex++, (byte)7, this.position);
                    break;
                }
                case 76: 
                case 108: {
                    this.setElementDataLength(elementBuffer, this.elementIndex++, (byte)2, this.position);
                    break;
                }
                case 62: {
                    this.setElementDataLength(elementBuffer, this.elementIndex++, (byte)8, this.position);
                    break;
                }
                case 60: {
                    this.setElementDataLength(elementBuffer, this.elementIndex++, (byte)9, this.position);
                    break;
                }
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: {
                    this.setElementDataLength(elementBuffer, this.elementIndex++, (byte)10, this.position);
                    break;
                }
                case 35: 
                case 43: {
                    this.parseSharp(buffer, elementBuffer);
                    break;
                }
                case 45: {
                    this.parseFlat(buffer, elementBuffer);
                    break;
                }
                case 78: 
                case 110: {
                    this.setElementDataLength(elementBuffer, this.elementIndex++, (byte)13, this.position);
                    break;
                }
                case 46: {
                    this.parseDot(buffer, elementBuffer);
                    break;
                }
                case 38: {
                    this.parseTie(buffer, elementBuffer);
                    break;
                }
                case 82: 
                case 114: {
                    this.setElementDataLength(elementBuffer, this.elementIndex++, (byte)16, this.position);
                    break;
                }
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    this.parseNumberToken(buffer, elementBuffer);
                    break;
                }
                case 77: {
                    this.parseMMLBegin(buffer, elementBuffer);
                    break;
                }
                case 44: {
                    this.parseChord(buffer, elementBuffer);
                    break;
                }
                case 59: {
                    this.parseEnd(buffer, elementBuffer);
                    break;
                }
            }
            ++this.position;
        }
        elementBuffer.setCount(this.elementIndex);
    }

    private void parseMMLBegin(DataByteBuffer buffer, IndexBuffer elementBuffer) {
        int tempPos = this.position;
        if (++tempPos < buffer.getLength() && buffer.getByte(tempPos) == 77 && ++tempPos < buffer.getLength() && buffer.getByte(tempPos) == 76 && ++tempPos < buffer.getLength() && buffer.getByte(tempPos) == 64 && ++tempPos < buffer.getLength()) {
            this.setElementData(elementBuffer, this.elementIndex, (byte)18, this.position, tempPos - this.position);
            this.position = tempPos - 1;
        }
        ++this.elementIndex;
    }

    private void parseNumberToken(DataByteBuffer buffer, IndexBuffer elementBuffer) {
        int tempPos = this.position;
        boolean isEndOfNumberFound = false;
        block3: while (!isEndOfNumberFound && ++tempPos < buffer.getLength()) {
            switch (buffer.getByte(tempPos)) {
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    continue block3;
                }
            }
            isEndOfNumberFound = true;
        }
        this.setElementData(elementBuffer, this.elementIndex, (byte)17, this.position, tempPos - this.position);
        this.position = tempPos - 1;
        ++this.elementIndex;
    }

    private void parseSharp(DataByteBuffer buffer, IndexBuffer elementBuffer) {
        int tempPos = this.position;
        boolean isEndOfRunFound = false;
        block3: while (!isEndOfRunFound && ++tempPos < buffer.getLength()) {
            switch (buffer.getByte(tempPos)) {
                case 35: 
                case 43: {
                    continue block3;
                }
            }
            isEndOfRunFound = true;
        }
        this.setElementData(elementBuffer, this.elementIndex, (byte)11, this.position, tempPos - this.position);
        this.position = tempPos - 1;
        ++this.elementIndex;
    }

    private void parseFlat(DataByteBuffer buffer, IndexBuffer elementBuffer) {
        int tempPos = this.position;
        boolean isEndOfRunFound = false;
        while (!isEndOfRunFound && ++tempPos < buffer.getLength()) {
            if (buffer.getByte(tempPos) == 45) continue;
            isEndOfRunFound = true;
        }
        this.setElementData(elementBuffer, this.elementIndex, (byte)12, this.position, tempPos - this.position);
        this.position = tempPos - 1;
        ++this.elementIndex;
    }

    private void parseDot(DataByteBuffer buffer, IndexBuffer elementBuffer) {
        int tempPos = this.position;
        boolean isEndOfRunFound = false;
        while (!isEndOfRunFound && ++tempPos < buffer.getLength()) {
            if (buffer.getByte(tempPos) == 46) continue;
            isEndOfRunFound = true;
        }
        this.setElementData(elementBuffer, this.elementIndex, (byte)14, this.position, tempPos - this.position);
        this.position = tempPos - 1;
        ++this.elementIndex;
    }

    private void parseTie(DataByteBuffer buffer, IndexBuffer elementBuffer) {
        int tempPos = this.position;
        boolean isEndOfRunFound = false;
        while (!isEndOfRunFound && ++tempPos < buffer.getLength()) {
            if (buffer.getByte(tempPos) == 38) continue;
            isEndOfRunFound = true;
        }
        this.setElementData(elementBuffer, this.elementIndex, (byte)15, this.position, tempPos - this.position);
        this.position = tempPos - 1;
        ++this.elementIndex;
    }

    private void parseChord(DataByteBuffer buffer, IndexBuffer elementBuffer) {
        int tempPos = this.position;
        boolean isEndOfRunFound = false;
        while (!isEndOfRunFound && ++tempPos < buffer.getLength()) {
            if (buffer.getByte(tempPos) == 44) continue;
            isEndOfRunFound = true;
        }
        this.setElementData(elementBuffer, this.elementIndex, (byte)19, this.position, tempPos - this.position);
        this.position = tempPos - 1;
        ++this.elementIndex;
    }

    private void parseEnd(DataByteBuffer buffer, IndexBuffer elementBuffer) {
        int tempPos = this.position;
        boolean isEndOfRunFound = false;
        while (!isEndOfRunFound && ++tempPos < buffer.getLength()) {
            if (buffer.getByte(tempPos) == 59) continue;
            isEndOfRunFound = true;
        }
        this.setElementData(elementBuffer, this.elementIndex, (byte)20, this.position, tempPos - this.position);
        this.position = tempPos - 1;
        ++this.elementIndex;
    }

    private void setElementDataLength(IndexBuffer elementBuffer, int index, byte type, int position) {
        elementBuffer.setType(index, type);
        elementBuffer.setPosition(index, position);
        elementBuffer.setLength(index, 1);
    }

    private void setElementData(IndexBuffer elementBuffer, int index, byte type, int position, int length) {
        elementBuffer.setType(index, type);
        elementBuffer.setPosition(index, position);
        elementBuffer.setLength(index, length);
    }
}

