/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.movingelevators.packets;

import com.supermartijn642.movingelevators.ElevatorBlockTile;
import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketElevatorName
implements IMessage,
IMessageHandler<PacketElevatorName, IMessage> {
    public BlockPos pos;
    public String name;

    public PacketElevatorName(BlockPos pos, String name) {
        this.pos = pos;
        this.name = name;
    }

    public PacketElevatorName() {
    }

    public void fromBytes(ByteBuf buf) {
        this.pos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
        if (buf.readBoolean()) {
            this.name = null;
        } else {
            byte[] bytes = new byte[buf.readInt()];
            buf.readBytes(bytes);
            this.name = new String(bytes, StandardCharsets.UTF_16);
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.pos.func_177958_n());
        buf.writeInt(this.pos.func_177956_o());
        buf.writeInt(this.pos.func_177952_p());
        buf.writeBoolean(this.name == null);
        if (this.name != null) {
            byte[] bytes = this.name.getBytes(StandardCharsets.UTF_16);
            buf.writeInt(bytes.length);
            buf.writeBytes(bytes);
        }
    }

    public IMessage onMessage(PacketElevatorName message, MessageContext ctx) {
        EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
        if (player == null) {
            return null;
        }
        World world = player.field_70170_p;
        if (world == null) {
            return null;
        }
        TileEntity tile = world.func_175625_s(message.pos);
        if (!(tile instanceof ElevatorBlockTile)) {
            return null;
        }
        player.func_184102_h().func_152344_a(() -> ((ElevatorBlockTile)tile).setFloorName(message.name));
        return null;
    }
}

