/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.movingelevators.gui;

import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.math.MathHelper;

public class ElevatorSpeedSlider
extends GuiButton {
    private static final int MIN = 1;
    private static final int MAX = 10;
    private float sliderValue;
    public boolean dragging;
    private final Consumer<ElevatorSpeedSlider> onChange;

    public ElevatorSpeedSlider(int xIn, int yIn, int widthIn, int heightIn, double currentValue, Consumer<ElevatorSpeedSlider> onChange) {
        super(0, xIn, yIn, widthIn, heightIn, "");
        this.sliderValue = ElevatorSpeedSlider.normalize((float)currentValue);
        this.onChange = onChange;
        this.updateMessage();
    }

    protected void updateMessage() {
        this.field_146126_j = I18n.func_135052_a((String)"movingelevators.platform.speed", (Object[])new Object[0]).replace("$number$", Double.toString(this.getValue()));
    }

    public double getValue() {
        return ElevatorSpeedSlider.denormalize(this.sliderValue);
    }

    private static float normalize(double value) {
        return (float)((int)(value * 10.0) - 1) / 9.0f;
    }

    private static double denormalize(float value) {
        return (double)(Math.round(value * 9.0f) + 1) / 10.0;
    }

    protected int func_146114_a(boolean mouseOver) {
        return 0;
    }

    protected void func_146119_b(Minecraft mc, int mouseX, int mouseY) {
        if (this.field_146125_m) {
            if (this.dragging) {
                this.sliderValue = (float)(mouseX - (this.field_146128_h + 4)) / (float)(this.field_146120_f - 8);
                this.sliderValue = MathHelper.func_76131_a((float)this.sliderValue, (float)0.0f, (float)1.0f);
                this.sliderValue = ElevatorSpeedSlider.normalize(ElevatorSpeedSlider.denormalize(this.sliderValue));
                this.updateMessage();
                this.onChange.accept(this);
            }
            mc.func_110434_K().func_110577_a(field_146122_a);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.func_73729_b(this.field_146128_h + (int)(this.sliderValue * (float)(this.field_146120_f - 8)), this.field_146129_i, 0, 66, 4, 20);
            this.func_73729_b(this.field_146128_h + (int)(this.sliderValue * (float)(this.field_146120_f - 8)) + 4, this.field_146129_i, 196, 66, 4, 20);
        }
    }

    public boolean func_146116_c(Minecraft mc, int mouseX, int mouseY) {
        if (super.func_146116_c(mc, mouseX, mouseY)) {
            this.sliderValue = (float)(mouseX - (this.field_146128_h + 4)) / (float)(this.field_146120_f - 8);
            this.sliderValue = MathHelper.func_76131_a((float)this.sliderValue, (float)0.0f, (float)1.0f);
            this.sliderValue = ElevatorSpeedSlider.normalize(ElevatorSpeedSlider.denormalize(this.sliderValue));
            this.updateMessage();
            this.onChange.accept(this);
            this.dragging = true;
            return true;
        }
        return false;
    }

    public void func_146118_a(int mouseX, int mouseY) {
        this.dragging = false;
    }
}

