/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.movingelevators.base;

import com.supermartijn642.movingelevators.MovingElevators;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;

public abstract class METile
extends TileEntity {
    private IBlockState camoState = Blocks.field_150350_a.func_176223_P();
    private boolean dataChanged = false;

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        if (!this.dataChanged) {
            return null;
        }
        this.dataChanged = false;
        NBTTagCompound compound = this.getChangedData();
        return compound == null || compound.func_82582_d() ? null : new SPacketUpdateTileEntity(this.field_174879_c, 0, compound);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.handleData(pkt.func_148857_g());
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound tag = super.func_189517_E_();
        tag.func_74782_a("info", (NBTBase)this.getAllData());
        return tag;
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        super.handleUpdateTag(tag);
        this.handleData(tag.func_74775_l("info"));
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74782_a("info", (NBTBase)this.getAllData());
        return compound;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.handleData(compound.func_74775_l("info"));
    }

    protected NBTTagCompound getChangedData() {
        NBTTagCompound data = new NBTTagCompound();
        data.func_74768_a("camoState", Block.func_176210_f((IBlockState)this.camoState));
        return data;
    }

    protected NBTTagCompound getAllData() {
        NBTTagCompound data = new NBTTagCompound();
        data.func_74768_a("camoState", Block.func_176210_f((IBlockState)this.camoState));
        return data;
    }

    protected void handleData(NBTTagCompound data) {
        ItemStack camoStack;
        Item item;
        if (data.func_74764_b("camoState")) {
            this.camoState = Block.func_176220_d((int)data.func_74762_e("camoState"));
        } else if (data.func_74764_b("hasCamo")) {
            this.camoState = data.func_74767_n("hasCamo") ? Block.func_176220_d((int)data.func_74762_e("camo")) : Blocks.field_150350_a.func_176223_P();
        } else if (data.func_74764_b("camo") && (item = (camoStack = new ItemStack(data.func_74775_l("camo"))).func_77973_b()) instanceof ItemBlock) {
            Block block = ((ItemBlock)item).func_179223_d();
            this.camoState = block.func_176223_P();
        }
    }

    public boolean setCamoState(IBlockState state) {
        this.camoState = state == null ? Blocks.field_150350_a.func_176223_P() : state;
        this.dataChanged();
        return true;
    }

    public boolean canBeCamoStack(ItemStack stack) {
        if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemBlock)) {
            return false;
        }
        Block block = ((ItemBlock)stack.func_77973_b()).func_179223_d();
        return !MovingElevators.CAMOUFLAGE_MOD_BLACKLIST.contains(block.getRegistryName().func_110624_b()) && this.isFullCube(block.func_176223_P());
    }

    private boolean isFullCube(IBlockState state) {
        for (EnumFacing side : EnumFacing.values()) {
            if (state.func_193401_d((IBlockAccess)this.field_145850_b, this.field_174879_c, side) == BlockFaceShape.SOLID) continue;
            return false;
        }
        return true;
    }

    public IBlockState getCamoBlock() {
        if (this.camoState.func_177230_c() == Blocks.field_150350_a) {
            return this.getBlockState();
        }
        return this.camoState;
    }

    public abstract EnumFacing getFacing();

    protected IBlockState getBlockState() {
        return this.field_145850_b.func_180495_p(this.field_174879_c);
    }

    protected void dataChanged() {
        this.dataChanged = true;
        this.field_145850_b.func_184138_a(this.field_174879_c, this.getBlockState(), this.getBlockState(), 2);
        this.func_70296_d();
    }
}

