/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.movingelevators;

import com.supermartijn642.movingelevators.ElevatorBlockTile;
import com.supermartijn642.movingelevators.ElevatorGroup;
import com.supermartijn642.movingelevators.MovingElevators;
import com.supermartijn642.movingelevators.packets.ElevatorGroupPacket;
import com.supermartijn642.movingelevators.packets.ElevatorGroupsPacket;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

@Mod.EventBusSubscriber
public class ElevatorGroupCapability {
    @CapabilityInject(value=ElevatorGroupCapability.class)
    public static Capability<ElevatorGroupCapability> CAPABILITY;
    private final World world;
    private final Map<ElevatorGroupPosition, ElevatorGroup> groups = new HashMap<ElevatorGroupPosition, ElevatorGroup>();

    public static void register() {
        CapabilityManager.INSTANCE.register(ElevatorGroupCapability.class, (Capability.IStorage)new Capability.IStorage<ElevatorGroupCapability>(){

            public NBTTagCompound writeNBT(Capability<ElevatorGroupCapability> capability, ElevatorGroupCapability instance, EnumFacing side) {
                return instance.write();
            }

            public void readNBT(Capability<ElevatorGroupCapability> capability, ElevatorGroupCapability instance, EnumFacing side, NBTBase nbt) {
                instance.read((NBTTagCompound)nbt);
            }
        }, ElevatorGroupCapability::new);
    }

    @SubscribeEvent
    public static void attachCapabilities(AttachCapabilitiesEvent<World> e) {
        World world = (World)e.getObject();
        final ElevatorGroupCapability capability = new ElevatorGroupCapability(world);
        e.addCapability(new ResourceLocation("movingelevators", "elevator_groups"), (ICapabilityProvider)new ICapabilitySerializable<NBTBase>(){

            public <T> T getCapability(@Nonnull Capability<T> cap, @Nullable EnumFacing side) {
                return (T)(cap == CAPABILITY ? CAPABILITY.cast((Object)capability) : null);
            }

            public boolean hasCapability(Capability<?> capability2, EnumFacing facing) {
                return capability2 == CAPABILITY;
            }

            public NBTBase serializeNBT() {
                return CAPABILITY.writeNBT((Object)capability, null);
            }

            public void deserializeNBT(NBTBase nbt) {
                CAPABILITY.readNBT((Object)capability, null, nbt);
            }
        });
    }

    @SubscribeEvent
    public static void onTick(TickEvent.WorldTickEvent e) {
        if (e.phase != TickEvent.Phase.END) {
            return;
        }
        ElevatorGroupCapability.tickWorldCapability(e.world);
    }

    public static void tickWorldCapability(World world) {
        ElevatorGroupCapability capability = (ElevatorGroupCapability)world.getCapability(CAPABILITY, null);
        if (capability != null) {
            capability.tick();
        }
    }

    @SubscribeEvent
    public static void onJoinWorld(PlayerEvent.PlayerChangedDimensionEvent e) {
        EntityPlayerMP player = (EntityPlayerMP)e.player;
        ElevatorGroupCapability groups = (ElevatorGroupCapability)player.field_70170_p.getCapability(CAPABILITY, null);
        if (groups != null) {
            MovingElevators.channel.sendTo((IMessage)new ElevatorGroupsPacket(groups.write()), player);
        }
    }

    @SubscribeEvent
    public static void onJoin(PlayerEvent.PlayerLoggedInEvent e) {
        EntityPlayerMP player = (EntityPlayerMP)e.player;
        ElevatorGroupCapability groups = (ElevatorGroupCapability)player.field_70170_p.getCapability(CAPABILITY, null);
        if (groups != null) {
            MovingElevators.channel.sendTo((IMessage)new ElevatorGroupsPacket(groups.write()), player);
        }
    }

    public ElevatorGroupCapability(World world) {
        this.world = world;
    }

    public ElevatorGroupCapability() {
        this.world = null;
    }

    public ElevatorGroup get(int x, int z, EnumFacing facing) {
        return this.groups.get(new ElevatorGroupPosition(x, z, facing));
    }

    public void add(ElevatorBlockTile controller) {
        ElevatorGroupPosition pos = new ElevatorGroupPosition(controller.func_174877_v(), controller.getFacing());
        this.groups.putIfAbsent(pos, new ElevatorGroup(this.world, pos.x, pos.z, pos.facing));
        this.groups.get(pos).add(controller);
    }

    public void remove(ElevatorBlockTile controller) {
        ElevatorGroupPosition pos = new ElevatorGroupPosition(controller.func_174877_v(), controller.getFacing());
        ElevatorGroup group = this.groups.get(pos);
        group.remove(controller);
        if (group.getFloorCount() == 0) {
            this.groups.remove(pos);
        }
    }

    public void tick() {
        for (ElevatorGroup group : this.groups.values()) {
            group.update();
        }
    }

    public void updateGroup(ElevatorGroup group) {
        if (!this.world.field_72995_K && group != null) {
            MovingElevators.channel.sendToDimension((IMessage)new ElevatorGroupPacket(this.writeGroup(group)), this.world.field_73011_w.getDimension());
        }
    }

    public ElevatorGroup getGroup(ElevatorBlockTile tile) {
        return this.groups.get(new ElevatorGroupPosition(tile.func_174877_v().func_177958_n(), tile.func_174877_v().func_177952_p(), tile.getFacing()));
    }

    public Collection<ElevatorGroup> getGroups() {
        return this.groups.values();
    }

    public NBTTagCompound write() {
        NBTTagCompound compound = new NBTTagCompound();
        for (Map.Entry<ElevatorGroupPosition, ElevatorGroup> entry : this.groups.entrySet()) {
            NBTTagCompound groupTag = new NBTTagCompound();
            groupTag.func_74782_a("group", (NBTBase)entry.getValue().write());
            groupTag.func_74782_a("pos", (NBTBase)entry.getKey().write());
            compound.func_74782_a(entry.getKey().x + ";" + entry.getKey().z, (NBTBase)groupTag);
        }
        return compound;
    }

    public void read(NBTTagCompound compound) {
        this.groups.clear();
        for (String key : compound.func_150296_c()) {
            NBTTagCompound groupTag = compound.func_74775_l(key);
            if (!groupTag.func_74764_b("group") || !groupTag.func_74764_b("pos")) continue;
            ElevatorGroupPosition pos = ElevatorGroupPosition.read(groupTag.func_74775_l("pos"));
            ElevatorGroup group = new ElevatorGroup(this.world, pos.x, pos.z, pos.facing);
            group.read(groupTag.func_74775_l("group"));
            this.groups.put(pos, group);
        }
    }

    private NBTTagCompound writeGroup(ElevatorGroup group) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74782_a("group", (NBTBase)group.write());
        tag.func_74782_a("pos", (NBTBase)new ElevatorGroupPosition(group.x, group.z, group.facing).write());
        return tag;
    }

    public void readGroup(NBTTagCompound tag) {
        if (tag.func_74764_b("group") && tag.func_74764_b("pos")) {
            ElevatorGroupPosition pos = ElevatorGroupPosition.read(tag.func_74775_l("pos"));
            ElevatorGroup group = new ElevatorGroup(this.world, pos.x, pos.z, pos.facing);
            group.read(tag.func_74775_l("group"));
            this.groups.put(pos, group);
        }
    }

    private static class ElevatorGroupPosition {
        public final int x;
        public final int z;
        public final EnumFacing facing;

        private ElevatorGroupPosition(int x, int z, EnumFacing facing) {
            this.x = x;
            this.z = z;
            this.facing = facing;
        }

        public ElevatorGroupPosition(BlockPos pos, EnumFacing facing) {
            this(pos.func_177958_n(), pos.func_177952_p(), facing);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ElevatorGroupPosition that = (ElevatorGroupPosition)o;
            if (this.x != that.x) {
                return false;
            }
            if (this.z != that.z) {
                return false;
            }
            return this.facing == that.facing;
        }

        public int hashCode() {
            int result = this.x;
            result = 31 * result + this.z;
            result = 31 * result + (this.facing != null ? this.facing.hashCode() : 0);
            return result;
        }

        public NBTTagCompound write() {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74768_a("x", this.x);
            tag.func_74768_a("z", this.z);
            tag.func_74768_a("facing", this.facing.func_176736_b());
            return tag;
        }

        public static ElevatorGroupPosition read(NBTTagCompound tag) {
            return new ElevatorGroupPosition(tag.func_74762_e("x"), tag.func_74762_e("z"), EnumFacing.func_176731_b((int)tag.func_74762_e("facing")));
        }
    }
}

