/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.movingelevators;

import com.supermartijn642.movingelevators.ElevatorBlockTile;
import com.supermartijn642.movingelevators.ElevatorGroupCapability;
import com.supermartijn642.movingelevators.FallDamageHandler;
import com.supermartijn642.movingelevators.MovingElevators;
import com.supermartijn642.movingelevators.packets.ElevatorMovementPacket;
import com.supermartijn642.movingelevators.packets.PacketOnElevator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class ElevatorGroup {
    private static final int RE_SYNC_INTERVAL = 10;
    public final World world;
    public final int x;
    public final int z;
    public final EnumFacing facing;
    private boolean isMoving = false;
    private int targetY;
    private double lastY;
    private double currentY;
    private double syncCurrentY = 2.147483647E9;
    private int size;
    private int nextSize = this.size = 3;
    private double speed;
    private double nextSpeed = this.speed = 0.2;
    private IBlockState[][] platform = new IBlockState[this.size][this.size];
    private final ArrayList<Integer> floors = new ArrayList();
    private final ArrayList<FloorData> floorData = new ArrayList();
    private int syncCounter = 0;

    public ElevatorGroup(World world, int x, int z, EnumFacing facing) {
        this.world = world;
        this.x = x;
        this.z = z;
        this.facing = facing;
    }

    public void update() {
        if (this.isMoving) {
            this.lastY = this.currentY;
            if (this.currentY == (double)this.targetY) {
                this.stopElevator();
            } else if (Math.abs((double)this.targetY - this.currentY) < this.speed) {
                this.currentY = this.targetY;
                this.moveElevator(this.lastY, this.currentY);
            } else {
                if (this.syncCurrentY != 2.147483647E9) {
                    this.currentY = this.syncCurrentY;
                    this.syncCurrentY = 2.147483647E9;
                } else {
                    this.currentY += Math.signum((double)this.targetY - this.currentY) * this.speed;
                }
                this.moveElevator(this.lastY, this.currentY);
            }
            if (this.syncCounter >= 10) {
                this.syncMovement();
                this.syncCounter = 0;
            }
            ++this.syncCounter;
        } else if (this.nextSize != this.size || this.nextSpeed != this.speed) {
            this.size = this.nextSize;
            this.speed = this.nextSpeed;
            this.platform = new IBlockState[this.size][this.size];
            this.updateGroup();
        }
    }

    private void moveElevator(double oldY, double newY) {
        int x = this.x + this.facing.func_82601_c() * (int)Math.ceil((float)this.size / 2.0f) - this.size / 2;
        int z = this.z + this.facing.func_82599_e() * (int)Math.ceil((float)this.size / 2.0f) - this.size / 2;
        AxisAlignedBB box = new AxisAlignedBB((double)x, Math.min(oldY, newY), (double)z, (double)(x + this.size), Math.max(oldY, newY) + 1.0 + 3.0 * this.speed, (double)(z + this.size));
        List entities = this.world.func_175647_a(Entity.class, box, this::canCollideWith);
        for (Entity entity : entities) {
            if (newY < oldY && entity.func_189652_ae() || entity instanceof EntityPlayer && entity.field_70181_x >= 0.0 && entity.field_70163_u > Math.min(oldY, newY) + 1.0) continue;
            entity.func_70107_b(entity.field_70165_t, newY + 1.0, entity.field_70161_v);
            entity.field_70122_E = true;
            entity.func_180430_e(entity.field_70143_R, 1.0f);
            entity.field_70143_R = 0.0f;
            entity.field_70181_x = 0.0;
            if (!(entity instanceof EntityPlayer)) continue;
            FallDamageHandler.resetElevatorTime((EntityPlayer)entity);
            if (!this.world.field_72995_K) continue;
            MovingElevators.channel.sendToServer((IMessage)new PacketOnElevator());
        }
    }

    private boolean canCollideWith(Entity entity) {
        return (!(entity instanceof EntityPlayer) || !((EntityPlayer)entity).func_175149_v()) && !entity.field_70145_X && entity.func_184192_z() == EnumPushReaction.NORMAL;
    }

    private void stopElevator() {
        this.isMoving = false;
        int startX = this.x + this.facing.func_82601_c() * (int)Math.ceil((float)this.size / 2.0f) - this.size / 2;
        int startZ = this.z + this.facing.func_82599_e() * (int)Math.ceil((float)this.size / 2.0f) - this.size / 2;
        for (int x = 0; x < this.size; ++x) {
            for (int z = 0; z < this.size; ++z) {
                BlockPos pos = new BlockPos(startX + x, this.targetY, startZ + z);
                if (!this.world.func_175623_d(pos)) {
                    this.world.func_175655_b(pos, true);
                }
                this.world.func_175656_a(pos, this.platform[x][z]);
            }
        }
        AxisAlignedBB box = new AxisAlignedBB((double)startX, this.currentY, (double)startZ, (double)(startX + this.size), this.currentY + 1.0, (double)(startZ + this.size));
        List entities = this.world.func_175647_a(Entity.class, box, this::canCollideWith);
        for (Entity entity : entities) {
            entity.func_70634_a(entity.field_70165_t, this.currentY + 1.0, entity.field_70161_v);
            entity.field_70122_E = true;
            entity.field_70143_R = 0.0f;
            entity.field_70181_x = 0.0;
        }
        if (!this.world.field_72995_K) {
            this.world.func_175666_e(this.getPos(this.targetY + 1), (Block)MovingElevators.elevator_block);
            this.updateGroup();
            double x = (double)(this.x + this.facing.func_82601_c() * (int)Math.ceil((float)this.size / 2.0f)) + 0.5;
            double z = (double)(this.z + this.facing.func_82599_e() * (int)Math.ceil((float)this.size / 2.0f)) + 0.5;
            this.world.func_184148_a(null, x, (double)this.targetY + 2.5, z, SoundEvents.field_187604_bf, SoundCategory.BLOCKS, 0.4f, 0.5f);
        }
    }

    private void startElevator(int currentY, int targetY) {
        int z;
        int x;
        if (this.world == null || this.isMoving) {
            return;
        }
        int startX = this.x + this.facing.func_82601_c() * (int)Math.ceil((float)this.size / 2.0f) - this.size / 2;
        int startZ = this.z + this.facing.func_82599_e() * (int)Math.ceil((float)this.size / 2.0f) - this.size / 2;
        for (x = 0; x < this.size; ++x) {
            for (z = 0; z < this.size; ++z) {
                BlockPos pos = new BlockPos(startX + x, currentY - 1, startZ + z);
                if (this.world.func_175623_d(pos) || this.world.func_175625_s(pos) != null) {
                    return;
                }
                IBlockState state = this.world.func_180495_p(pos);
                if (state.func_185887_b(this.world, pos) < 0.0f) {
                    return;
                }
                AxisAlignedBB collisionBox = state.func_185890_d((IBlockAccess)this.world, pos);
                if (collisionBox == null || collisionBox.field_72337_e != 1.0 || collisionBox.field_72340_a != 0.0 || collisionBox.field_72336_d != 1.0 || collisionBox.field_72339_c != 0.0 || collisionBox.field_72334_f != 1.0) {
                    return;
                }
                this.platform[x][z] = state;
            }
        }
        for (x = 0; x < this.size; ++x) {
            for (z = 0; z < this.size; ++z) {
                this.world.func_175656_a(new BlockPos(startX + x, currentY - 1, startZ + z), Blocks.field_150350_a.func_176223_P());
            }
        }
        this.isMoving = true;
        this.targetY = targetY - 1;
        this.lastY = this.currentY = (double)(currentY - 1);
        if (!this.world.field_72995_K) {
            this.world.func_175666_e(this.getPos(currentY), (Block)MovingElevators.elevator_block);
            this.updateGroup();
        }
    }

    public void onButtonPress(boolean isUp, boolean isDown, int yLevel) {
        if (this.isMoving || !this.floors.contains(yLevel)) {
            return;
        }
        ElevatorBlockTile tile = this.getTile(yLevel);
        if (tile == null) {
            return;
        }
        if (isUp) {
            if (tile.hasPlatform()) {
                for (int floor = this.floors.indexOf(yLevel) + 1; floor < this.floors.size(); ++floor) {
                    ElevatorBlockTile tile2 = this.getTile(this.floors.get(floor));
                    if (tile2 == null) continue;
                    if (tile2.hasSpaceForPlatform()) {
                        this.startElevator(yLevel, this.floors.get(floor));
                    }
                    return;
                }
            }
        } else if (isDown) {
            if (tile.hasPlatform()) {
                for (int floor = this.floors.indexOf(yLevel) - 1; floor >= 0; --floor) {
                    ElevatorBlockTile tile2 = this.getTile(this.floors.get(floor));
                    if (tile2 == null) continue;
                    if (tile2.hasSpaceForPlatform()) {
                        this.startElevator(yLevel, this.floors.get(floor));
                    }
                    return;
                }
            }
        } else if (tile.hasSpaceForPlatform()) {
            this.floors.sort(Comparator.comparingInt(a -> Math.abs(a - yLevel)));
            for (int y : this.floors) {
                ElevatorBlockTile tile2;
                if (y == yLevel || (tile2 = this.getTile(y)) == null || !tile2.hasPlatform()) continue;
                this.floors.sort(Integer::compare);
                this.startElevator(y, yLevel);
                return;
            }
            this.floors.sort(Integer::compare);
        }
    }

    public void onDisplayPress(int yLevel, int floorOffset) {
        if (this.isMoving || !this.floors.contains(yLevel)) {
            return;
        }
        int floor = this.floors.indexOf(yLevel);
        if (floorOffset == 0) {
            this.onButtonPress(false, false, yLevel);
            return;
        }
        int toFloor = floor + floorOffset;
        if (toFloor < 0 || toFloor >= this.floors.size()) {
            return;
        }
        ElevatorBlockTile tile = this.getTile(yLevel);
        int toY = this.floors.get(toFloor);
        ElevatorBlockTile toTile = this.getTile(toY);
        if (tile != null && toTile != null && tile.hasPlatform() && toTile.hasSpaceForPlatform()) {
            this.startElevator(yLevel, toY);
        }
    }

    public void remove(ElevatorBlockTile tile) {
        int floor = this.getFloorNumber(tile.func_174877_v().func_177956_o());
        this.floors.remove(floor);
        this.floorData.remove(floor);
        if (this.floors.isEmpty()) {
            if (this.isMoving) {
                BlockPos spawnPos = this.getPos(tile.func_174877_v().func_177956_o()).func_177967_a(this.facing, this.size / 2 + 1);
                IBlockState[][] iBlockStateArray = this.platform;
                int n = iBlockStateArray.length;
                for (int i = 0; i < n; ++i) {
                    IBlockState[] arr;
                    for (IBlockState state : arr = iBlockStateArray[i]) {
                        EntityItem entity = new EntityItem(this.world, (double)spawnPos.func_177958_n() + 0.5, (double)spawnPos.func_177956_o() + 0.5, (double)spawnPos.func_177952_p() + 0.5, new ItemStack(state.func_177230_c()));
                        this.world.func_72838_d((Entity)entity);
                    }
                }
            }
        } else {
            this.updateGroup();
        }
    }

    public void add(ElevatorBlockTile tile) {
        if (tile == null) {
            return;
        }
        int y = tile.func_174877_v().func_177956_o();
        if (this.floors.contains(y)) {
            return;
        }
        FloorData floorData = new FloorData(tile.getFloorName(), tile.getDisplayLabelColor());
        for (int i = 0; i < this.floors.size(); ++i) {
            if (y >= this.floors.get(i)) continue;
            this.floors.add(i, y);
            this.floorData.add(i, floorData);
            break;
        }
        if (!this.floors.contains(y)) {
            this.floors.add(y);
            this.floorData.add(floorData);
        }
        this.updateGroup();
    }

    public void updateFloorData(ElevatorBlockTile tile, String name, EnumDyeColor color) {
        int floor = this.getFloorNumber(tile.func_174877_v().func_177956_o());
        if (floor == -1) {
            return;
        }
        FloorData data = this.floorData.get(floor);
        if (!Objects.equals(name, data.name) || color != data.color) {
            data.name = name;
            data.color = color;
            this.updateGroup();
        }
    }

    public boolean isMoving() {
        return this.isMoving;
    }

    public double getLastY() {
        return this.lastY;
    }

    public double getCurrentY() {
        return this.currentY;
    }

    public void updateCurrentY(double y) {
        if (this.isMoving && (this.currentY < this.lastY ? y < this.currentY : y > this.currentY)) {
            this.syncCurrentY = y;
        }
    }

    public IBlockState[][] getPlatform() {
        return this.platform;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.nextSize = size;
    }

    public double getSpeed() {
        return this.speed;
    }

    public void setSpeed(double speed) {
        this.nextSpeed = speed;
    }

    public EnumDyeColor getFloorDisplayColor(int floor) {
        return this.floorData.get((int)floor).color;
    }

    public String getFloorDisplayName(int floor) {
        return this.floorData.get((int)floor).name;
    }

    public NBTTagCompound write() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74757_a("moving", this.isMoving);
        tag.func_74768_a("size", this.size);
        if (this.isMoving) {
            tag.func_74768_a("targetY", this.targetY);
            tag.func_74780_a("lastY", this.lastY);
            tag.func_74780_a("currentY", this.currentY);
            for (int x = 0; x < this.size; ++x) {
                for (int z = 0; z < this.size; ++z) {
                    tag.func_74768_a("platform" + x + "," + z, Block.func_176210_f((IBlockState)this.platform[x][z]));
                }
            }
        }
        tag.func_74780_a("speed", this.speed);
        int[] arr = new int[this.floors.size()];
        for (int i = 0; i < this.floors.size(); ++i) {
            arr[i] = this.floors.get(i);
        }
        tag.func_74783_a("floors", arr);
        NBTTagList floorDataTag = new NBTTagList();
        for (FloorData floorDatum : this.floorData) {
            floorDataTag.func_74742_a((NBTBase)floorDatum.write());
        }
        tag.func_74782_a("floorData", (NBTBase)floorDataTag);
        return tag;
    }

    public void read(NBTTagCompound tag) {
        if (tag.func_74764_b("moving")) {
            this.isMoving = tag.func_74767_n("moving");
        }
        if (tag.func_74764_b("targetY")) {
            this.targetY = tag.func_74762_e("targetY");
        }
        if (tag.func_74764_b("lastY")) {
            this.lastY = tag.func_74769_h("lastY");
        }
        if (tag.func_74764_b("currentY")) {
            this.currentY = tag.func_74769_h("currentY");
        }
        if (tag.func_74764_b("size")) {
            this.nextSize = this.size = tag.func_74762_e("size");
            this.platform = new IBlockState[this.size][this.size];
        }
        if (tag.func_74764_b("speed")) {
            this.nextSpeed = this.speed = tag.func_74769_h("speed");
        }
        for (int x = 0; x < this.size; ++x) {
            for (int z = 0; z < this.size; ++z) {
                this.platform[x][z] = Block.func_176220_d((int)tag.func_74762_e("platform" + x + "," + z));
            }
        }
        if (tag.func_74764_b("floors")) {
            this.floors.clear();
            for (int y : tag.func_74759_k("floors")) {
                this.floors.add(y);
            }
        }
        if (tag.func_74764_b("floorData")) {
            this.floorData.clear();
            NBTBase base = tag.func_74781_a("floorData");
            if (base instanceof NBTTagList) {
                NBTTagList floorDataTag = (NBTTagList)base;
                for (NBTBase compound : floorDataTag) {
                    this.floorData.add(FloorData.read((NBTTagCompound)compound));
                }
            }
        }
    }

    private BlockPos getPos(int y) {
        return new BlockPos(this.x, y, this.z);
    }

    private ElevatorBlockTile getTile(int y) {
        if (this.world == null) {
            return null;
        }
        TileEntity tile = this.world.func_175625_s(this.getPos(y));
        return tile instanceof ElevatorBlockTile ? (ElevatorBlockTile)tile : null;
    }

    public int getFloorCount() {
        return this.floors.size();
    }

    public int getFloorNumber(int y) {
        return this.floors.indexOf(y);
    }

    public int getFloorYLevel(int floor) {
        return this.floors.get(floor);
    }

    public ElevatorBlockTile getTileForFloor(int floor) {
        if (floor < 0 || floor >= this.floors.size()) {
            return null;
        }
        return this.getTile(this.floors.get(floor));
    }

    private void updateGroup() {
        ElevatorGroupCapability groups = (ElevatorGroupCapability)this.world.getCapability(ElevatorGroupCapability.CAPABILITY, null);
        if (groups != null) {
            groups.updateGroup(this);
        }
    }

    private void syncMovement() {
        if (!this.world.field_72995_K) {
            MovingElevators.channel.sendToDimension((IMessage)new ElevatorMovementPacket(this.x, this.z, this.facing, this.currentY), this.world.field_73011_w.getDimension());
        }
    }

    private static class FloorData {
        public String name;
        public EnumDyeColor color;

        public FloorData(String name, EnumDyeColor color) {
            this.name = name;
            this.color = color;
        }

        public NBTTagCompound write() {
            NBTTagCompound tag = new NBTTagCompound();
            if (this.name != null) {
                tag.func_74778_a("name", this.name);
            }
            tag.func_74768_a("color", this.color.func_176767_b());
            return tag;
        }

        public static FloorData read(NBTTagCompound tag) {
            return new FloorData(tag.func_74764_b("name") ? tag.func_74779_i("name") : null, EnumDyeColor.func_176766_a((int)tag.func_74762_e("color")));
        }
    }
}

