/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.movingelevators;

import com.supermartijn642.movingelevators.ElevatorBlock;
import com.supermartijn642.movingelevators.ElevatorGroup;
import com.supermartijn642.movingelevators.ElevatorGroupCapability;
import com.supermartijn642.movingelevators.base.ElevatorInputTile;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public class ElevatorBlockTile
extends ElevatorInputTile {
    private boolean initialized = false;
    private EnumFacing facing;
    private String name;
    private EnumDyeColor color = EnumDyeColor.GRAY;

    @Override
    public void func_73660_a() {
        ElevatorGroupCapability groups;
        if (!this.initialized && (groups = (ElevatorGroupCapability)this.field_145850_b.getCapability(ElevatorGroupCapability.CAPABILITY, null)) != null) {
            groups.add(this);
            this.getGroup().updateFloorData(this, this.name, this.color);
            this.initialized = true;
        }
    }

    public boolean hasPlatform() {
        int startX = this.field_174879_c.func_177958_n() + this.getFacing().func_82601_c() * (int)Math.ceil((float)this.getGroup().getSize() / 2.0f) - this.getGroup().getSize() / 2;
        int startZ = this.field_174879_c.func_177952_p() + this.getFacing().func_82599_e() * (int)Math.ceil((float)this.getGroup().getSize() / 2.0f) - this.getGroup().getSize() / 2;
        for (int x = 0; x < this.getGroup().getSize(); ++x) {
            for (int z = 0; z < this.getGroup().getSize(); ++z) {
                BlockPos pos = new BlockPos(startX + x, this.field_174879_c.func_177956_o() - 1, startZ + z);
                if (this.field_145850_b.func_175623_d(pos) || this.field_145850_b.func_175625_s(pos) != null) {
                    return false;
                }
                IBlockState state = this.field_145850_b.func_180495_p(pos);
                if (state.func_185887_b(this.field_145850_b, pos) < 0.0f) {
                    return false;
                }
                AxisAlignedBB collisionBox = state.func_185890_d((IBlockAccess)this.field_145850_b, pos);
                if (collisionBox != null && collisionBox.field_72337_e == 1.0 && collisionBox.field_72340_a == 0.0 && collisionBox.field_72336_d == 1.0 && collisionBox.field_72339_c == 0.0 && collisionBox.field_72334_f == 1.0) continue;
                return false;
            }
        }
        return true;
    }

    public boolean hasSpaceForPlatform() {
        int startX = this.field_174879_c.func_177958_n() + this.getFacing().func_82601_c() * (int)Math.ceil((float)this.getGroup().getSize() / 2.0f) - this.getGroup().getSize() / 2;
        int startZ = this.field_174879_c.func_177952_p() + this.getFacing().func_82599_e() * (int)Math.ceil((float)this.getGroup().getSize() / 2.0f) - this.getGroup().getSize() / 2;
        for (int x = 0; x < this.getGroup().getSize(); ++x) {
            for (int z = 0; z < this.getGroup().getSize(); ++z) {
                BlockPos pos = new BlockPos(startX + x, this.field_174879_c.func_177956_o() - 1, startZ + z);
                if (this.field_145850_b.func_175623_d(pos)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public EnumFacing getFacing() {
        if (this.facing == null) {
            this.facing = (EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)ElevatorBlock.FACING);
        }
        return this.facing;
    }

    @Override
    protected NBTTagCompound getChangedData() {
        NBTTagCompound data = super.getChangedData();
        if (this.name != null) {
            data.func_74778_a("name", this.name);
        }
        data.func_74768_a("color", this.color.func_176765_a());
        return data;
    }

    @Override
    protected NBTTagCompound getAllData() {
        NBTTagCompound data = super.getAllData();
        if (this.name != null) {
            data.func_74778_a("name", this.name);
        }
        data.func_74768_a("color", this.color.func_176765_a());
        return data;
    }

    @Override
    protected void handleData(NBTTagCompound tag) {
        super.handleData(tag);
        String string = this.name = tag.func_74764_b("name") ? tag.func_74779_i("name") : null;
        if (tag.func_74764_b("color")) {
            this.color = EnumDyeColor.func_176764_b((int)tag.func_74762_e("color"));
        }
    }

    public void onBreak() {
        ElevatorGroupCapability groups = (ElevatorGroupCapability)this.field_145850_b.getCapability(ElevatorGroupCapability.CAPABILITY, null);
        if (groups != null) {
            groups.remove(this);
        }
    }

    public double func_145833_n() {
        return 260100.0;
    }

    @Override
    public String getFloorName() {
        return this.name;
    }

    public void setFloorName(String name) {
        this.name = name;
        this.dataChanged();
        if (this.hasGroup()) {
            this.getGroup().updateFloorData(this, this.name, this.color);
        }
    }

    public void setDisplayLabelColor(EnumDyeColor color) {
        this.color = color;
        this.dataChanged();
        if (this.hasGroup()) {
            this.getGroup().updateFloorData(this, this.name, this.color);
        }
    }

    @Override
    public EnumDyeColor getDisplayLabelColor() {
        return this.color;
    }

    @Override
    public ElevatorGroup getGroup() {
        ElevatorGroupCapability groups = (ElevatorGroupCapability)this.field_145850_b.getCapability(ElevatorGroupCapability.CAPABILITY, null);
        return groups == null ? null : groups.getGroup(this);
    }

    @Override
    public boolean hasGroup() {
        return this.initialized;
    }

    @Override
    public int getFloorLevel() {
        return this.field_174879_c.func_177956_o();
    }
}

