/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.movingelevators;

import com.supermartijn642.movingelevators.ButtonBlockTile;
import com.supermartijn642.movingelevators.CommonProxy;
import com.supermartijn642.movingelevators.ElevatorBlockTile;
import com.supermartijn642.movingelevators.ElevatorGroupCapability;
import com.supermartijn642.movingelevators.MovingElevators;
import com.supermartijn642.movingelevators.base.ElevatorInputTileRenderer;
import com.supermartijn642.movingelevators.gui.ElevatorScreen;
import com.supermartijn642.movingelevators.model.MEBlockBakedModel;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(value={Side.CLIENT})
public class ClientProxy
extends CommonProxy {
    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> e) {
        ClientRegistry.bindTileEntitySpecialRenderer(ElevatorBlockTile.class, new ElevatorInputTileRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(ButtonBlockTile.class, new ElevatorInputTileRenderer());
    }

    @SubscribeEvent
    public static void registerModels(ModelRegistryEvent e) {
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)MovingElevators.elevator_block), (int)0, (ModelResourceLocation)new ModelResourceLocation(MovingElevators.elevator_block.getRegistryName(), "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)MovingElevators.display_block), (int)0, (ModelResourceLocation)new ModelResourceLocation(MovingElevators.display_block.getRegistryName(), "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)MovingElevators.button_block), (int)0, (ModelResourceLocation)new ModelResourceLocation(MovingElevators.button_block.getRegistryName(), "inventory"));
    }

    @SubscribeEvent
    public static void onModelBake(ModelBakeEvent e) {
        ClientProxy.setCamouflageModel(e, MovingElevators.elevator_block);
        ClientProxy.setCamouflageModel(e, MovingElevators.display_block);
        ClientProxy.setCamouflageModel(e, MovingElevators.button_block);
    }

    private static void setCamouflageModel(ModelBakeEvent e, Block block) {
        for (IBlockState state : block.func_176194_O().func_177619_a()) {
            StringBuilder builder = new StringBuilder();
            if (!state.func_177228_b().isEmpty()) {
                builder.append(state.func_177228_b().entrySet().stream().map(entry -> ClientProxy.getPropertyName((IProperty)entry.getKey(), (Comparable)entry.getValue())).collect(Collectors.joining(",")));
            }
            ModelResourceLocation modelLocation = new ModelResourceLocation(block.getRegistryName(), builder.toString());
            IBakedModel model = e.getModelManager().func_174953_a(modelLocation);
            e.getModelRegistry().func_82595_a((Object)modelLocation, (Object)new MEBlockBakedModel(model));
        }
    }

    private static <T extends Comparable<T>> String getPropertyName(IProperty<T> property, Comparable<?> value) {
        return property.func_177701_a() + "=" + property.func_177702_a(value);
    }

    public static void openElevatorScreen(BlockPos pos) {
        Minecraft.func_71410_x().func_147108_a((GuiScreen)new ElevatorScreen(pos));
    }

    public static String translate(String s) {
        return I18n.func_135052_a((String)s, (Object[])new Object[0]);
    }

    public static String formatFloorDisplayName(String name, int floor) {
        return name == null ? ClientProxy.translate("movingelevators.floorname").replace("$number$", Integer.toString(floor)) : name;
    }

    public static EntityPlayer getPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent e) {
        if (e.phase == TickEvent.Phase.END && !Minecraft.func_71410_x().func_147113_T() && Minecraft.func_71410_x().field_71441_e != null) {
            ElevatorGroupCapability.tickWorldCapability((World)Minecraft.func_71410_x().field_71441_e);
        }
    }

    public static void queTask(Runnable task) {
        Minecraft.func_71410_x().func_152344_a(task);
    }
}

