/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.camera.net;

import de.maxhenkel.camera.ImageTools;
import de.maxhenkel.camera.TextureCache;
import io.netty.buffer.ByteBuf;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class MessageImage
implements IMessage,
IMessageHandler<MessageImage, IMessage> {
    private UUID uuid;
    private byte[] image;

    public MessageImage() {
    }

    public MessageImage(UUID uuid, byte[] image) {
        this.uuid = uuid;
        this.image = image;
    }

    public IMessage onMessage(MessageImage message, MessageContext ctx) {
        try {
            BufferedImage img = ImageTools.fromBytes(message.image);
            Minecraft.func_71410_x().func_152344_a(() -> TextureCache.instance().addImage(message.uuid, img));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public void fromBytes(ByteBuf buf) {
        long l1 = buf.readLong();
        long l2 = buf.readLong();
        this.uuid = new UUID(l1, l2);
        int length = buf.readInt();
        this.image = new byte[length];
        buf.readBytes(this.image);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeLong(this.uuid.getMostSignificantBits());
        buf.writeLong(this.uuid.getLeastSignificantBits());
        buf.writeInt(this.image.length);
        buf.writeBytes(this.image);
    }
}

