/*
 * Decompiled with CFR 0.152.
 */
package net.soggymustache.bookworm.util;

import com.google.gson.Gson;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Optional;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Loader;
import net.soggymustache.bookworm.BookwormMain;

public class UserChangeable<T> {
    public final File ROOT;
    public boolean enableDebug = true;
    public Gson gson;
    public final Class<T> CLAZZ;
    public String modID = "";
    public String folder = "";

    public UserChangeable(Class<T> clazz, File file, String folder, Gson gson, String modID) {
        this.ROOT = file;
        this.gson = gson;
        this.CLAZZ = clazz;
        this.modID = modID;
        this.folder = folder;
    }

    public UserChangeable(Class<T> clazz, String folder, Gson gson, String modID) {
        this(clazz, new File(Loader.instance().getConfigDir().getAbsolutePath() + File.separator + folder + File.separator + "data"), folder, gson, modID);
    }

    public void syncDataToClient() {
    }

    public Optional<InputStreamReader> getAlternative(String location) {
        File f = new File(this.ROOT.getAbsolutePath(), location);
        if (f.exists()) {
            if (this.enableDebug) {
                BookwormMain.LOGGER.info("Found alternative for " + location);
            }
            try {
                return Optional.of(new InputStreamReader(new FileInputStream(f)));
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
        return Optional.empty();
    }

    public T load(ResourceLocation location) {
        try {
            Optional<InputStreamReader> option = this.getAlternative(location.toString());
            if (option.isPresent()) {
                return (T)this.gson.fromJson((Reader)option.get(), this.CLAZZ);
            }
            return (T)this.gson.fromJson((Reader)new InputStreamReader(UserChangeable.class.getResourceAsStream("/assets/" + location.func_110624_b() + "/" + location.func_110623_a())), this.CLAZZ);
        }
        catch (Exception e) {
            if (this.enableDebug) {
                BookwormMain.LOGGER.error("Failed to load : " + location);
                e.printStackTrace();
            }
            return null;
        }
    }
}

